/*
 * Decompiled with CFR 0.152.
 */
package pro.cloudnode.smp.anvilunlocker;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AnvilUnlocker
extends JavaPlugin
implements Listener {
    private int maximumCost = Short.MAX_VALUE;

    public void onEnable() {
        this.saveDefaultConfig();
        this.maximumCost = AnvilUnlocker.constrainAnvilMax(this.getConfig().getInt("maximumCost"));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.maximumCost = AnvilUnlocker.constrainAnvilMax(this.getConfig().getInt("maximumCost"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onInventoryClose(@NotNull InventoryCloseEvent event) {
        if (event.getInventory() instanceof AnvilInventory && event.getPlayer() instanceof Player && event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.setInstantBuild((Player)event.getPlayer(), false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPrepareAnvil(@NotNull PrepareAnvilEvent event) {
        if (!(event.getView().getPlayer() instanceof Player) || event.getView().getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        AnvilInventory anvil = event.getInventory();
        anvil.setMaximumRepairCost(this.maximumCost);
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            ItemStack input2 = anvil.getItem(1);
            this.setInstantBuild((Player)event.getView().getPlayer(), input2 == null || input2.getType() == Material.AIR || anvil.getRepairCost() < anvil.getMaximumRepairCost());
        });
    }

    public void setInstantBuild(@NotNull Player player, boolean instantBuild) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ABILITIES);
        packet.getBooleans().write(0, (Object)player.isInvulnerable());
        packet.getBooleans().write(1, (Object)player.isFlying());
        packet.getBooleans().write(2, (Object)player.getAllowFlight());
        packet.getBooleans().write(3, (Object)instantBuild);
        packet.getFloat().write(0, (Object)Float.valueOf(player.getFlySpeed() / 2.0f));
        packet.getFloat().write(1, (Object)Float.valueOf(player.getWalkSpeed() / 2.0f));
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    private static int constrainAnvilMax(int actual) {
        return Math.min(Short.MAX_VALUE, Math.max(41, actual));
    }
}

