/*
 * Decompiled with CFR 0.152.
 */
package net.legendaryporpoise.believemod.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.legendaryporpoise.believemod.block.custom.CycledBlockItem;
import net.legendaryporpoise.believemod.block.families.ArchitectureFamily;
import net.legendaryporpoise.believemod.block.families.BuildingBlocksFamily;
import net.legendaryporpoise.believemod.block.families.ColumnsFamily;
import net.legendaryporpoise.believemod.block.families.ExtDecoFamily;
import net.legendaryporpoise.believemod.block.families.FoodFamily;
import net.legendaryporpoise.believemod.block.families.FurnitureFamily;
import net.legendaryporpoise.believemod.block.families.IntDecoFamily;
import net.legendaryporpoise.believemod.block.families.LandscapeFamily;
import net.legendaryporpoise.believemod.block.families.NatureFamily;
import net.legendaryporpoise.believemod.block.families.PlasterFamily;
import net.legendaryporpoise.believemod.block.families.RoofingFamily;
import net.legendaryporpoise.believemod.block.families.TudorFamily;
import net.legendaryporpoise.believemod.block.families.WallDecoFamily;
import net.legendaryporpoise.believemod.block.families.WoodFamily;
import net.legendaryporpoise.believemod.block.families.WorkstationsFamily;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModBlocks {
    private static final Map<class_2248, List<class_1799>> BLOCK_PALETTES = new HashMap<class_2248, List<class_1799>>();
    public static final List<class_2248> BLOCKS = new ArrayList<class_2248>();

    public static void registerModBlocks() {
        ArchitectureFamily.registerFamily();
        BuildingBlocksFamily.registerFamily();
        ColumnsFamily.registerFamily();
        ExtDecoFamily.registerFamily();
        FoodFamily.registerFamily();
        IntDecoFamily.registerFamily();
        NatureFamily.registerFamily();
        WallDecoFamily.registerFamily();
        WorkstationsFamily.registerFamily();
        WoodFamily.registerFamily();
        RoofingFamily.registerFamily();
        LandscapeFamily.registerFamily();
        WorkstationsFamily.registerFamily();
        PlasterFamily.registerFamily();
        FurnitureFamily.registerFamily();
        TudorFamily.registerFamily();
    }

    public static class_2248 registerBlock(String name, class_2248 block) {
        class_2248 registeredBlock = (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("believemod", name), (Object)block);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("believemod", name), (Object)new class_1747(registeredBlock, (class_1792.class_1793)new FabricItemSettings()));
        BLOCKS.add(registeredBlock);
        return registeredBlock;
    }

    public static void registerFamily(String name, List<class_2248> blocks) {
        List<class_1799> palette = blocks.stream().map(class_1799::new).toList();
        blocks.forEach(block -> BLOCK_PALETTES.put((class_2248)block, palette));
    }

    public static class_2248 getBlock(String name) {
        class_2960 id = new class_2960("believemod", name);
        return (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalArgumentException("Block not found: " + name));
    }

    private static class_2248 registerCycledBlock(String name, class_2248 block) {
        class_2248 registeredBlock = (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("believemod", name), (Object)block);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("believemod", name), (Object)((Object)new CycledBlockItem(block, (class_1792.class_1793)new FabricItemSettings())));
        return registeredBlock;
    }

    private static void registerBlockItem(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("believemod", name), (Object)new class_1747(block, (class_1792.class_1793)new FabricItemSettings()));
    }

    public static List<class_1799> getPaletteForBlock(class_2248 block) {
        return BLOCK_PALETTES.getOrDefault(block, List.of());
    }
}

