/*
 * Decompiled with CFR 0.152.
 */
package net.legendaryporpoise.believemod.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.legendaryporpoise.believemod.client.model.YOffsetModelLoadingPlugin;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class YOffsetAwareBakedModel
implements class_1087,
FabricBakedModel {
    private final class_1087 base;
    private final RenderMaterial defaultMaterial;
    private final String modelIdStr;
    private static final boolean DEBUG_ONCE = false;
    private static final Set<String> LOGGED = ConcurrentHashMap.newKeySet();

    public YOffsetAwareBakedModel(class_1087 base) {
        this(base, (String)null);
    }

    public YOffsetAwareBakedModel(class_1087 base, class_2960 id) {
        this(base, id == null ? null : id.toString());
    }

    public YOffsetAwareBakedModel(class_1087 base, String modelIdStr) {
        this.base = Objects.requireNonNull(base, "base");
        this.modelIdStr = modelIdStr;
        Renderer r = RendererAccess.INSTANCE.getRenderer();
        if (r == null) {
            if (modelIdStr != null && LOGGED.add(modelIdStr)) {
                System.out.println("[believemod] Fabric Renderer not found; YOffsetAwareBakedModel will pass through.");
            }
            this.defaultMaterial = null;
        } else {
            this.defaultMaterial = r.materialFinder().find();
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> rand, RenderContext ctx) {
        if (RendererAccess.INSTANCE.getRenderer() == null || this.defaultMaterial == null || this.isExcluded(this.modelIdStr)) {
            this.passthrough(state, rand, ctx.getEmitter());
            return;
        }
        float fractionBelow = this.getVanillaSnowFraction(world, pos == null ? null : pos.method_10074());
        if (fractionBelow >= 0.9999f) {
            this.passthrough(state, rand, ctx.getEmitter());
            return;
        }
        float shiftY = fractionBelow - 1.0f;
        RenderContext.QuadTransform transform = q -> {
            if (shiftY == 0.0f) {
                return true;
            }
            for (int i = 0; i < 4; ++i) {
                q.pos(i, q.x(i), q.y(i) + shiftY, q.z(i));
            }
            q.nominalFace(this.faceFromNormal(q));
            return true;
        };
        ctx.pushTransform(transform);
        this.passthrough(state, rand, ctx.getEmitter());
        ctx.popTransform();
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> rand, RenderContext ctx) {
        ArrayList<class_777> all = new ArrayList<class_777>();
        all.addAll(this.base.method_4707(null, null, rand.get()));
        for (class_2350 d : class_2350.values()) {
            all.addAll(this.base.method_4707(null, d, rand.get()));
        }
        this.emit(all, ctx.getEmitter());
    }

    private float getVanillaSnowFraction(class_1920 world, class_2338 pos) {
        if (world == null || pos == null) {
            return 1.0f;
        }
        class_2680 bs = world.method_8320(pos);
        if (bs == null) {
            return 1.0f;
        }
        class_2758 prop = this.findLayerOrLayersProperty(bs.method_28501());
        if (prop == null) {
            return 1.0f;
        }
        Integer val = (Integer)bs.method_11654((class_2769)prop);
        if (val == null) {
            return 1.0f;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Integer v : prop.method_11898()) {
            if (v == null) continue;
            if (v < min) {
                min = v;
            }
            if (v <= max) continue;
            max = v;
        }
        if (min == Integer.MAX_VALUE || max == Integer.MIN_VALUE) {
            return 1.0f;
        }
        int totalSteps = max - min + 1;
        if (totalSteps <= 0) {
            return 1.0f;
        }
        int currentStep = val - min + 1;
        if (currentStep < 1) {
            currentStep = 1;
        }
        if (currentStep > totalSteps) {
            currentStep = totalSteps;
        }
        return (float)currentStep / (float)totalSteps;
    }

    private class_2758 findLayerOrLayersProperty(Collection<class_2769<?>> props) {
        for (class_2769<?> p : props) {
            if (!(p instanceof class_2758)) continue;
            class_2758 ip = (class_2758)p;
            String name = p.method_11899();
            if (!"layer".equals(name) && !"layers".equals(name)) continue;
            return ip;
        }
        return null;
    }

    private void passthrough(class_2680 state, Supplier<class_5819> rand, QuadEmitter emitter) {
        List general = this.base.method_4707(state, null, rand.get());
        this.emit(general, emitter);
        for (class_2350 d : class_2350.values()) {
            this.emit(this.base.method_4707(state, d, rand.get()), emitter);
        }
    }

    private void emit(List<class_777> quads, QuadEmitter emitter) {
        if (quads == null || quads.isEmpty()) {
            return;
        }
        for (class_777 q : quads) {
            emitter.fromVanilla(q, this.defaultMaterial, null);
            emitter.emit();
        }
    }

    private class_2350 faceFromNormal(MutableQuadView q) {
        float ax = q.x(1) - q.x(0);
        float ay = q.y(1) - q.y(0);
        float az = q.z(1) - q.z(0);
        float bx = q.x(2) - q.x(0);
        float by = q.y(2) - q.y(0);
        float bz = q.z(2) - q.z(0);
        float nx = ay * bz - az * by;
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float axn = Math.abs(nx);
        float ayn = Math.abs(ny);
        float azn = Math.abs(nz);
        if (axn >= ayn && axn >= azn) {
            return nx >= 0.0f ? class_2350.field_11039 : class_2350.field_11034;
        }
        if (ayn >= axn && ayn >= azn) {
            return ny >= 0.0f ? class_2350.field_11033 : class_2350.field_11036;
        }
        return nz >= 0.0f ? class_2350.field_11043 : class_2350.field_11035;
    }

    private boolean isExcluded(String id) {
        if (id == null) {
            return false;
        }
        try {
            for (String prefix : YOffsetModelLoadingPlugin.EXCLUDED) {
                if (!id.startsWith(prefix)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, class_5819 random) {
        return this.base.method_4707(state, face, random);
    }

    public boolean method_4708() {
        return this.base.method_4708();
    }

    public boolean method_4712() {
        return this.base.method_4712();
    }

    public boolean method_24304() {
        return this.base.method_24304();
    }

    public boolean method_4713() {
        return this.base.method_4713();
    }

    public class_1058 method_4711() {
        return this.base.method_4711();
    }

    public class_809 method_4709() {
        return this.base.method_4709();
    }

    public class_806 method_4710() {
        return this.base.method_4710();
    }
}

