/*
 * Decompiled with CFR 0.152.
 */
package net.legendaryporpoise.believemod.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.legendaryporpoise.believemod.client.model.YOffsetAwareBakedModel;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class YOffsetModelLoadingPlugin {
    private static volatile String MODID = "believemod";
    private static final AtomicBoolean EXCLUDES_LOADED = new AtomicBoolean(false);
    public static final Set<String> EXCLUDED = new HashSet<String>();
    private static final AtomicInteger WRAPPED_COUNT = new AtomicInteger(0);

    public static void init(String modid) {
        MODID = modid == null || modid.isBlank() ? "believemod" : modid;
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.modifyModelAfterBake().register((model, ctx) -> {
            class_2960 id = ctx.id();
            if (!MODID.equals(id.method_12836())) {
                return model;
            }
            if (!id.method_12832().startsWith("block/")) {
                return model;
            }
            YOffsetModelLoadingPlugin.loadExcludesIfNeeded();
            if (YOffsetModelLoadingPlugin.isExcluded(id)) {
                return model;
            }
            if (model instanceof YOffsetAwareBakedModel) {
                return model;
            }
            WRAPPED_COUNT.incrementAndGet();
            return new YOffsetAwareBakedModel(model, id);
        }));
    }

    private static boolean isExcludedInternal(String namespaceColonPath) {
        for (String prefix : EXCLUDED) {
            if (!namespaceColonPath.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcluded(class_1091 id) {
        String key = id.method_12836() + ":" + id.method_12832();
        return YOffsetModelLoadingPlugin.isExcludedInternal(key);
    }

    public static boolean isExcluded(class_2960 id) {
        String key = id.method_12836() + ":" + id.method_12832();
        return YOffsetModelLoadingPlugin.isExcludedInternal(key);
    }

    public static boolean isExcluded(String namespaceColonPath) {
        return YOffsetModelLoadingPlugin.isExcludedInternal(namespaceColonPath);
    }

    private static void loadExcludesIfNeeded() {
        if (EXCLUDES_LOADED.get()) {
            return;
        }
        class_2960 jsonLoc = new class_2960(MODID, "y_offset_model_exclude.json");
        class_3300 rm = class_310.method_1551().method_1478();
        try {
            for (class_3298 res : rm.method_14489(jsonLoc)) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(res.method_14482(), StandardCharsets.UTF_8));){
                    JsonObject root = (JsonObject)new Gson().fromJson((Reader)br, JsonObject.class);
                    if (root == null || !root.has("values")) continue;
                    JsonArray arr = root.getAsJsonArray("values");
                    arr.forEach(el -> {
                        String s = el.getAsString().trim();
                        if (!s.isEmpty()) {
                            EXCLUDED.add(s);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EXCLUDES_LOADED.set(true);
    }
}

