/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import vilantious.pvptoggle.PvPToggleCore;
import vilantious.pvptoggle.config.ConfigManager;
import vilantious.pvptoggle.util.FeedbackHelper;
import vilantious.pvptoggle.util.TextBuilderUtil;
import vilantious.pvptoggle.util.TimeFormatterUtil;

public class PvPCommand {
    private static final SimpleCommandExceptionType INVALID_GLOBAL_STATE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"pvptoggle.error.invalid_global_state"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pvp").executes(PvPCommand::togglePvP)).requires(Permissions.require((String)"pvptoggle.player.toggle", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"pvptoggle.op.reload", (int)2))).executes(PvPCommand::reloadConfigSubCommand))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"pvptoggle.op.other.toggle", (int)2))).executes(PvPCommand::togglePlayerPvPSubCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"timeout").requires(Permissions.require((String)"pvptoggle.op.other.timeout", (int)2))).then(class_2170.method_9244((String)"duration", (ArgumentType)FloatArgumentType.floatArg((float)20.0f, (float)600.0f)).executes(PvPCommand::timeoutPlayerSubCommand))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"global").requires(Permissions.require((String)"pvptoggle.op.global", (int)2))).then(class_2170.method_9244((String)"state", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (PvPToggleCore.globalPvPState state : PvPToggleCore.globalPvPState.values()) {
                builder.suggest(String.valueOf((Object)state).toLowerCase());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"shouldBroadcast", (ArgumentType)BoolArgumentType.bool()).executes(PvPCommand::globalPvPOverrideSubCommand))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"status").requires(Permissions.require((String)"pvptoggle.player.status", (boolean)true))).executes(PvPCommand::pvpStatusSubCommand)).then(class_2170.method_9247((String)"flag").executes(PvPCommand::toggleFlagDisplaySubCommand))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"pvptoggle.op.other.status", (int)2))).executes(PvPCommand::playerPvPStatusSubCommand))));
    }

    private static int togglePvP(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        PvPToggleCore.playerState playerState2 = PvPToggleCore.playerStateResolver(sourcePlayer);
        switch (playerState2) {
            case NORMAL: {
                PvPToggleCore.putPlayerOnCooldown(sourcePlayer);
                PvPToggleCore.togglePvP(sourcePlayer);
                class_5250 toggle = TextBuilderUtil.constructBoolean(PvPToggleCore.isPvPToggled(sourcePlayer), "pvptoggle.on", "pvptoggle.off");
                class_5250 toggleSwitch = TextBuilderUtil.constructTranslatable("pvptoggle.switch.prefix", (class_2561)toggle);
                sourcePlayer.method_7353((class_2561)toggleSwitch, true);
                break;
            }
            case TIMED_OUT: {
                ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructTranslatable("pvptoggle.toggle.timeout", (class_2561)class_2561.method_43470((String)TimeFormatterUtil.formatTimer(PvPToggleCore.getRemainingTimeout(sourcePlayer))), TextBuilderUtil.FORMAT_RED), false);
                break;
            }
            case FLAGGED: {
                ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructTranslatable("pvptoggle.toggle.flagged", TextBuilderUtil.FORMAT_RED), false);
                break;
            }
            case COOLDOWN: {
                ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructTranslatable("pvptoggle.toggle.cooldown", (class_2561)class_2561.method_43470((String)TimeFormatterUtil.formatTimer(PvPToggleCore.getRemainingCooldown(sourcePlayer))), TextBuilderUtil.FORMAT_RED), false);
            }
        }
        class_3414 soundEvent = FeedbackHelper.fetchFeedbackSound(playerState2);
        FeedbackHelper.playSoundToPlayer(sourcePlayer, soundEvent);
        return 1;
    }

    private static int togglePlayerPvPSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        PvPToggleCore.togglePvP(otherPlayer);
        class_5250 toggle = TextBuilderUtil.constructBoolean(PvPToggleCore.isPvPToggled(otherPlayer), "pvptoggle.on", "pvptoggle.off");
        class_5250 switchOther = TextBuilderUtil.constructTranslatable("pvptoggle.switch.other.prefix", (class_2561)toggle);
        class_5250 switchSource = TextBuilderUtil.constructTranslatable("pvptoggle.switch.prefix", (class_2561)toggle);
        class_5250 switchOtherSuffix = TextBuilderUtil.constructTranslatable("pvptoggle.switch.other.suffix", otherPlayer.method_5476());
        ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)switchSource).method_10852((class_2561)switchOtherSuffix), ConfigManager.getInstance().broadcastToOtherOps);
        otherPlayer.method_7353((class_2561)switchOther, true);
        FeedbackHelper.playSoundToPlayer(otherPlayer);
        return 1;
    }

    private static int timeoutPlayerSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        float duration = FloatArgumentType.getFloat(context, (String)"duration");
        if (PvPToggleCore.isPlayerTimedOut(otherPlayer)) {
            ((class_2168)context.getSource()).method_45068((class_2561)TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)TextBuilderUtil.constructTranslatable("pvptoggle.timeout.already_timed_out", otherPlayer.method_5476())));
            return 0;
        }
        PvPToggleCore.timeoutPlayer(otherPlayer, duration);
        class_5250 lockOther = TextBuilderUtil.constructTranslatable("pvptoggle.timeout", otherPlayer.method_5476(), (class_2561)TextBuilderUtil.constructLiteral(TimeFormatterUtil.formatTimer((int)duration), TextBuilderUtil.FORMAT_RED));
        class_5250 notifyLocked = TextBuilderUtil.constructTranslatable("pvptoggle.warning.timeout", TextBuilderUtil.FORMAT_RED);
        ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)lockOther), ConfigManager.getInstance().broadcastToOtherOps);
        otherPlayer.method_7353((class_2561)notifyLocked, true);
        FeedbackHelper.playSoundToPlayer(otherPlayer);
        return 1;
    }

    private static int globalPvPOverrideSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)context.getSource();
        String globalStateArgument = StringArgumentType.getString(context, (String)"state");
        boolean shouldBroadcastArgument = BoolArgumentType.getBool(context, (String)"shouldBroadcast");
        PvPToggleCore.globalPvPState newGlobalState = PvPToggleCore.tryFetchNewGlobalState(globalStateArgument);
        if (newGlobalState == null) {
            throw INVALID_GLOBAL_STATE.create();
        }
        if (PvPToggleCore.getPvPGlobalState() == newGlobalState) {
            serverCommandSource.method_45068((class_2561)TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)TextBuilderUtil.constructTranslatable("pvptoggle.switch.global.already_set")));
            return 0;
        }
        PvPToggleCore.setPvPGlobalState(newGlobalState);
        class_5250 pvpStateGlobal = TextBuilderUtil.constructBooleanPrefix(false).method_10852((class_2561)TextBuilderUtil.constructGlobalState(newGlobalState));
        if (shouldBroadcastArgument) {
            FeedbackHelper.sendGlobalFeedback(serverCommandSource.method_9211(), (class_2561)pvpStateGlobal, true);
        }
        return 1;
    }

    private static int pvpStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        class_5250 toggle = TextBuilderUtil.constructBoolean(PvPToggleCore.isPvPToggled(sourcePlayer), "pvptoggle.on", "pvptoggle.off");
        class_5250 status = TextBuilderUtil.constructTranslatable("pvptoggle.status.pvp", (class_2561)toggle);
        sourcePlayer.method_7353((class_2561)status, true);
        return 1;
    }

    private static int playerPvPStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        class_5250 cooldownTimer = TextBuilderUtil.constructStatusTimer(PvPToggleCore.getRemainingCooldown(otherPlayer));
        class_5250 flagTimer = TextBuilderUtil.constructStatusTimer(PvPToggleCore.getRemainingFlag(otherPlayer));
        class_5250 timeoutTimer = TextBuilderUtil.constructStatusTimer(PvPToggleCore.getRemainingTimeout(otherPlayer));
        class_5250 dashPrefix = TextBuilderUtil.constructLiteral("-", TextBuilderUtil.FORMAT_GRAY);
        class_5250 otherStatus = TextBuilderUtil.constructTranslatable("pvptoggle.status.other.pvp", otherPlayer.method_5476());
        class_5250 toggle = TextBuilderUtil.constructBoolean(PvPToggleCore.isPvPToggled(otherPlayer), "pvptoggle.on", "pvptoggle.off");
        class_5250 pvpStatus = TextBuilderUtil.constructTranslatable("pvptoggle.status.other.toggle", (class_2561)dashPrefix, (class_2561)toggle);
        class_5250 cooldown = TextBuilderUtil.constructBoolean(PvPToggleCore.isPlayerOnCooldown(otherPlayer), "pvptoggle.true", "pvptoggle.false");
        class_5250 cooldownStatus = TextBuilderUtil.constructTranslatable("pvptoggle.status.other.cooldown", (class_2561)dashPrefix, (class_2561)cooldown, (class_2561)cooldownTimer);
        class_5250 flag = TextBuilderUtil.constructBoolean(PvPToggleCore.isPlayerFlagged(otherPlayer), "pvptoggle.true", "pvptoggle.false");
        class_5250 flagStatus = TextBuilderUtil.constructTranslatable("pvptoggle.status.other.flag", (class_2561)dashPrefix, (class_2561)flag, (class_2561)flagTimer);
        class_5250 timeout = TextBuilderUtil.constructBoolean(PvPToggleCore.isPlayerTimedOut(otherPlayer), "pvptoggle.true", "pvptoggle.false");
        class_5250 timeoutStatus = TextBuilderUtil.constructTranslatable("pvptoggle.status.other.timeout", (class_2561)dashPrefix, (class_2561)timeout, (class_2561)timeoutTimer);
        ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)otherStatus).method_10852((class_2561)pvpStatus).method_10852((class_2561)cooldownStatus).method_10852((class_2561)flagStatus).method_10852((class_2561)timeoutStatus), ConfigManager.getInstance().broadcastToOtherOps);
        return 1;
    }

    public static int toggleFlagDisplaySubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        PvPToggleCore.toggleFlagTimer(sourcePlayer);
        class_5250 toggle = TextBuilderUtil.constructBoolean(PvPToggleCore.isFlagDisplayOn(sourcePlayer), "pvptoggle.on", "pvptoggle.off");
        class_5250 displayToggle = TextBuilderUtil.constructTranslatable("pvptoggle.status.timer.toggle", (class_2561)toggle);
        sourcePlayer.method_64398((class_2561)TextBuilderUtil.constructBooleanPrefix(false).method_10852((class_2561)displayToggle));
        FeedbackHelper.playSoundToPlayer(sourcePlayer);
        return 1;
    }

    private static int reloadConfigSubCommand(CommandContext<class_2168> context) {
        try {
            ConfigManager.load();
            ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.constructBooleanPrefix(true).method_10852((class_2561)TextBuilderUtil.constructTranslatable("pvptoggle.config.reload")), ConfigManager.getInstance().broadcastToOtherOps);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_45068((class_2561)TextBuilderUtil.constructTranslatable("pvptoggle.config.failed_reload", TextBuilderUtil.FORMAT_RED));
        }
        return 1;
    }
}

