/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;
import vilantious.pvptoggle.PvPToggle;
import vilantious.pvptoggle.config.PvPToggleConfig;

public class PvPToggleCore {
    private static final PvPToggleConfig PVP_TOGGLE_CONFIG = PvPToggleConfig.getInstance();
    private static final Map<UUID, Long> toggleCooldown = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> combatFlag = new HashMap<UUID, Long>();

    public static boolean togglePvP(class_3222 serverPlayer) {
        boolean currentValue = (Boolean)serverPlayer.getAttachedOrCreate(PvPToggle.PVP_TOGGLE_ATTACHMENT);
        boolean newValue = !currentValue;
        serverPlayer.setAttached(PvPToggle.PVP_TOGGLE_ATTACHMENT, (Object)newValue);
        return (Boolean)serverPlayer.getAttachedOrThrow(PvPToggle.PVP_TOGGLE_ATTACHMENT);
    }

    public static boolean isPvPToggled(class_3222 serverPlayer) {
        return (Boolean)serverPlayer.getAttachedOrCreate(PvPToggle.PVP_TOGGLE_ATTACHMENT);
    }

    public static void putPlayerOnCooldown(class_3222 serverPlayer) {
        UUID uuid = serverPlayer.method_5667();
        long time = serverPlayer.method_37908().method_8510();
        if (!toggleCooldown.containsKey(uuid)) {
            toggleCooldown.put(uuid, time);
        }
    }

    public static void queryPlayerCooldown(class_3222 serverPlayer) {
        PvPToggleCore.removeIfExpired(serverPlayer, toggleCooldown, PvPToggleCore.PVP_TOGGLE_CONFIG.toggleCooldown);
    }

    public static boolean isPlayerOnCooldown(class_3222 serverPlayer) {
        return toggleCooldown.containsKey(serverPlayer.method_5667());
    }

    public static void flagPlayers(class_3222[] participants) {
        for (class_3222 participant : participants) {
            if (participant.method_64475(4) && PvPToggleCore.PVP_TOGGLE_CONFIG.opIgnoreFlag) continue;
            UUID uuid = participant.method_5667();
            long time = participant.method_37908().method_8510();
            combatFlag.put(uuid, time);
        }
    }

    public static void queryPlayerFlag(class_3222 serverPlayer) {
        PvPToggleCore.removeIfExpired(serverPlayer, combatFlag, PvPToggleCore.PVP_TOGGLE_CONFIG.combatFlagDuration);
    }

    public static boolean isPlayerFlagged(class_3222 serverPlayer) {
        return combatFlag.containsKey(serverPlayer.method_5667());
    }

    public static void removeIfExpired(class_3222 serverPlayer, Map<UUID, Long> pvpMap, int cooldown) {
        long oldTime;
        if (!pvpMap.containsKey(serverPlayer.method_5667())) {
            return;
        }
        UUID uuid = serverPlayer.method_5667();
        long currentTime = serverPlayer.method_37908().method_8510();
        long elapsed = currentTime - (oldTime = pvpMap.get(uuid).longValue());
        if (elapsed >= (long)cooldown) {
            pvpMap.remove(uuid);
        }
    }

    public static boolean isNotSelfDamage(class_3222 attacker, class_3222 victim) {
        return !attacker.method_5667().equals(victim.method_5667());
    }
}

