/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class PvPToggleConfig {
    public int toggleCooldown = 2400;
    public int combatFlagDuration = 1200;
    public boolean opIgnoreCooldown = false;
    public boolean opIgnoreFlag = false;
    private static PvPToggleConfig instance;

    public static PvPToggleConfig getInstance() {
        if (instance == null) {
            instance = PvPToggleConfig.loadConfig();
        }
        return instance;
    }

    public static PvPToggleConfig createDefault() {
        return new PvPToggleConfig();
    }

    public static PvPToggleConfig loadConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path configFile = configDir.resolve("pvptoggle-config.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!Files.exists(configFile, new LinkOption[0])) {
                PvPToggleConfig pvpConfig = PvPToggleConfig.createDefault();
                String json = gson.toJson((Object)pvpConfig);
                Files.writeString(configFile, (CharSequence)json, StandardOpenOption.CREATE_NEW);
                return pvpConfig;
            }
            String json = Files.readString(configFile);
            return (PvPToggleConfig)gson.fromJson(json, PvPToggleConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load or create PvPToggleConfig", e);
        }
    }
}

