/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle.init;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import vilantious.pvptoggle.PvPToggleCore;
import vilantious.pvptoggle.config.PvPToggleConfig;
import vilantious.pvptoggle.util.FeedbackUtil;

public class ModCommands {
    private static final PvPToggleConfig PVP_TOGGLE_CONFIG = PvPToggleConfig.getInstance();
    private static final SimpleCommandExceptionType INVALID_PLAYER_SOURCE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"pvptoggle.error.invalid_source"));

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pvp").executes(ModCommands::toggleSelfPvPCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(ModCommands::toggleOtherPvPCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"status").executes(ModCommands::pvpStatusSubCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(ModCommands::pvpOtherStatusSubCommand)))));
    }

    private static int toggleSelfPvPCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean isValidOp;
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
        if (sourcePlayer == null) {
            throw INVALID_PLAYER_SOURCE.create();
        }
        boolean playerCooldown = PvPToggleCore.isPlayerOnCooldown(sourcePlayer);
        boolean playerFlag = PvPToggleCore.isPlayerFlagged(sourcePlayer);
        boolean bl = isValidOp = sourcePlayer.method_64475(4) && ModCommands.PVP_TOGGLE_CONFIG.opIgnoreCooldown;
        if (!playerCooldown && !playerFlag) {
            class_5250 toggle;
            boolean pvpToggleSwitch;
            if (!sourcePlayer.method_7337() && !isValidOp) {
                PvPToggleCore.putPlayerOnCooldown(sourcePlayer);
            }
            if (pvpToggleSwitch = PvPToggleCore.togglePvP(sourcePlayer)) {
                class_5250 suffix = class_2561.method_43470((String)"!").method_27692(class_124.field_1068);
                toggle = class_2561.method_43471((String)"pvptoggle.on").method_27692(class_124.field_1061).method_10852((class_2561)suffix);
            } else {
                class_5250 suffix = class_2561.method_43470((String)".").method_27692(class_124.field_1068);
                toggle = class_2561.method_43471((String)"pvptoggle.off").method_27692(class_124.field_1060).method_10852((class_2561)suffix);
            }
            sourcePlayer.method_7353((class_2561)class_2561.method_43471((String)"pvptoggle.switch").method_10852((class_2561)toggle), true);
        } else if (playerFlag) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"pvptoggle.flagged").method_27692(class_124.field_1061), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"pvptoggle.cooldown").method_27692(class_124.field_1061), false);
        }
        FeedbackUtil.playFeedbackSoundEvent(sourcePlayer, playerFlag, playerCooldown);
        return 1;
    }

    private static int toggleOtherPvPCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_5250 suffix;
        class_5250 toggle;
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        if (otherPlayer == null) {
            throw class_2168.field_9824.create();
        }
        boolean pvpToggleSwitch = PvPToggleCore.togglePvP(otherPlayer);
        class_5250 switchPrefix = class_2561.method_43471((String)"pvptoggle.switch.other.prefix").method_27692(class_124.field_1068);
        class_5250 switchSuffix = class_2561.method_43469((String)"pvptoggle.switch.other.suffix", (Object[])new Object[]{otherPlayer.method_5476()}).method_27692(class_124.field_1068);
        if (pvpToggleSwitch) {
            toggle = class_2561.method_43471((String)"pvptoggle.on").method_27692(class_124.field_1061);
            suffix = class_2561.method_43470((String)"!").method_27692(class_124.field_1068);
        } else {
            toggle = class_2561.method_43471((String)"pvptoggle.off").method_27692(class_124.field_1060);
            suffix = class_2561.method_43470((String)".").method_27692(class_124.field_1068);
        }
        ((class_2168)context.getSource()).method_9226(() -> ModCommands.lambda$toggleOtherPvPCommand$5((class_2561)switchPrefix, toggle, (class_2561)switchSuffix), false);
        otherPlayer.method_7353((class_2561)class_2561.method_43471((String)"pvptoggle.switch.other.notification").method_10852((class_2561)toggle).method_10852((class_2561)suffix), true);
        otherPlayer.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15248, 1.0f, 0.8f + 0.2f * otherPlayer.method_59922().method_43057());
        return 1;
    }

    private static int pvpStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_5250 suffix;
        class_5250 toggle;
        class_3222 serverPlayer = ((class_2168)context.getSource()).method_44023();
        if (serverPlayer == null) {
            throw INVALID_PLAYER_SOURCE.create();
        }
        boolean pvpToggled = PvPToggleCore.isPvPToggled(serverPlayer);
        if (pvpToggled) {
            toggle = class_2561.method_43471((String)"pvptoggle.on").method_27692(class_124.field_1061);
            suffix = class_2561.method_43470((String)"!").method_27692(class_124.field_1068);
        } else {
            toggle = class_2561.method_43471((String)"pvptoggle.off").method_27692(class_124.field_1060);
            suffix = class_2561.method_43470((String)".").method_27692(class_124.field_1068);
        }
        class_5250 pvpStatus = class_2561.method_43471((String)"pvptoggle.status").method_10852((class_2561)toggle).method_10852((class_2561)suffix);
        serverPlayer.method_7353((class_2561)pvpStatus, true);
        return 1;
    }

    private static int pvpOtherStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 serverPlayer = class_2186.method_9315(context, (String)"player");
        if (serverPlayer == null) {
            throw class_2168.field_9824.create();
        }
        boolean pvpToggled = PvPToggleCore.isPvPToggled(serverPlayer);
        class_5250 status = class_2561.method_43471((String)"pvptoggle.status").method_27692(class_124.field_1068);
        class_5250 suffix = class_2561.method_43469((String)"pvptoggle.switch.other.suffix", (Object[])new Object[]{serverPlayer.method_5476()}).method_27692(class_124.field_1068);
        class_5250 toggle = pvpToggled ? class_2561.method_43471((String)"pvptoggle.on").method_27692(class_124.field_1061) : class_2561.method_43471((String)"pvptoggle.off").method_27692(class_124.field_1060);
        ((class_2168)context.getSource()).method_9226(() -> ModCommands.lambda$pvpOtherStatusSubCommand$6((class_2561)status, toggle, (class_2561)suffix), false);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$pvpOtherStatusSubCommand$6(class_2561 status, class_5250 toggle, class_2561 suffix) {
        return class_2561.method_43470((String)"[PvPToggle] ").method_27692(class_124.field_1080).method_10852(status).method_10852((class_2561)toggle).method_10852(suffix);
    }

    private static /* synthetic */ class_2561 lambda$toggleOtherPvPCommand$5(class_2561 switchPrefix, class_5250 toggle, class_2561 switchSuffix) {
        return class_2561.method_43470((String)"[PvPToggle] ").method_27692(class_124.field_1080).method_10852(switchPrefix).method_10852((class_2561)toggle).method_10852(switchSuffix);
    }
}

