/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import vilantious.pvptoggle.config.ConfigManager;
import vilantious.pvptoggle.init.ModAttachments;

public class PvPToggleCore {
    private static final Map<UUID, Long> playersOnCooldown = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> combatFlaggedPlayers = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> timedOutPlayers = new HashMap<UUID, Long>();
    private static globalPvPState globalState = globalPvPState.NEUTRAL;
    private static final Map<String, globalPvPState> globalStateMap = new HashMap<String, globalPvPState>();

    public static playerState playerStateResolver(class_3222 serverPlayer) {
        if (PvPToggleCore.isPlayerTimedOut(serverPlayer)) {
            return playerState.TIMED_OUT;
        }
        if (PvPToggleCore.isPlayerFlagged(serverPlayer)) {
            return playerState.FLAGGED;
        }
        if (PvPToggleCore.isPlayerOnCooldown(serverPlayer)) {
            return playerState.COOLDOWN;
        }
        return playerState.NORMAL;
    }

    public static void togglePvP(class_3222 serverPlayer) {
        PvPToggleCore.toggleAttachment(serverPlayer, ModAttachments.PVP_TOGGLE_ATTACHMENT);
    }

    public static void toggleFlagTimer(class_3222 serverPlayer) {
        PvPToggleCore.toggleAttachment(serverPlayer, ModAttachments.DISPLAY_FLAG_TIMER_ATTACHMENT);
    }

    private static void toggleAttachment(class_3222 serverPlayer, AttachmentType<Boolean> attachment) {
        boolean currentValue = (Boolean)serverPlayer.getAttachedOrCreate(attachment);
        boolean newValue = !currentValue;
        serverPlayer.setAttached(attachment, (Object)newValue);
    }

    public static boolean isPvPToggled(class_3222 serverPlayer) {
        return (Boolean)serverPlayer.getAttachedOrCreate(ModAttachments.PVP_TOGGLE_ATTACHMENT);
    }

    public static void putPlayerOnCooldown(class_3222 serverPlayer) {
        PvPToggleCore.putInMap(serverPlayer, playersOnCooldown, ConfigManager.getInstance().toggleCooldown);
    }

    public static void flagPlayer(class_3222 serverPlayer) {
        PvPToggleCore.flagPlayers(new class_3222[]{serverPlayer});
    }

    public static void flagPlayers(class_3222[] participants) {
        for (class_3222 participant : participants) {
            if (!participant.method_5805()) continue;
            UUID playerUuid = participant.method_5667();
            long expiration = (long)(ConfigManager.getInstance().combatFlagDuration * 1000.0f);
            combatFlaggedPlayers.put(playerUuid, System.currentTimeMillis() + expiration);
        }
    }

    public static void timeoutPlayer(class_3222 serverPlayer, float duration) {
        PvPToggleCore.putInMap(serverPlayer, timedOutPlayers, duration);
    }

    private static void putInMap(class_3222 serverPlayer, Map<UUID, Long> pvpMap, float time) {
        UUID playerUuid = serverPlayer.method_5667();
        if (pvpMap.containsKey(playerUuid)) {
            return;
        }
        long expiration = (long)(time * 1000.0f);
        pvpMap.put(playerUuid, System.currentTimeMillis() + expiration);
    }

    public static void queryFlaggedPlayers() {
        PvPToggleCore.removeIfExpired(combatFlaggedPlayers);
    }

    public static void queryPlayersOnCooldown() {
        PvPToggleCore.removeIfExpired(playersOnCooldown);
    }

    public static void queryTimedOutPlayers() {
        PvPToggleCore.removeIfExpired(timedOutPlayers);
    }

    public static boolean isPlayerOnCooldown(class_3222 serverPlayer) {
        return PvPToggleCore.keyLookup(serverPlayer, playersOnCooldown);
    }

    public static boolean isPlayerFlagged(class_3222 serverPlayer) {
        return PvPToggleCore.keyLookup(serverPlayer, combatFlaggedPlayers);
    }

    public static boolean isPlayerTimedOut(class_3222 serverPlayer) {
        return PvPToggleCore.keyLookup(serverPlayer, timedOutPlayers);
    }

    public static boolean isFlagDisplayOff(class_3222 serverPlayer) {
        return (Boolean)serverPlayer.getAttachedOrCreate(ModAttachments.DISPLAY_FLAG_TIMER_ATTACHMENT);
    }

    private static boolean keyLookup(class_3222 serverPlayer, Map<UUID, Long> pvpMap) {
        return pvpMap.containsKey(serverPlayer.method_5667());
    }

    public static boolean maybePunishCombatLog(class_3222 serverPlayer) {
        if (!ConfigManager.getInstance().punishCombatLog) {
            return false;
        }
        if (!PvPToggleCore.isPlayerFlagged(serverPlayer)) {
            return false;
        }
        serverPlayer.method_5768(serverPlayer.method_51469());
        return true;
    }

    public static void clearFlagOnKilled(class_3222 serverPlayer) {
        if (PvPToggleCore.isPlayerFlagged(serverPlayer)) {
            combatFlaggedPlayers.remove(serverPlayer.method_5667());
        }
    }

    public static boolean isNotSelfDamage(class_3222 attacker, class_1657 victim) {
        return !attacker.method_5667().equals(victim.method_5667());
    }

    public static boolean isNotValidTameable(class_1297 entity, class_3222 attacker) {
        if (!ConfigManager.getInstance().protectTameables) {
            return true;
        }
        if (entity instanceof class_6025) {
            class_6025 tameable = (class_6025)entity;
            if (tameable.method_66287() == null) {
                return true;
            }
            return attacker == tameable.method_35057();
        }
        return true;
    }

    public static boolean isPvPForcedInOtherDimensions(class_1297 entity) {
        return ConfigManager.getInstance().forcePvPInOtherDimensions && entity.method_37908().method_27983() != class_1937.field_25179;
    }

    public static globalPvPState tryFetchNewGlobalState(String stringArgument) {
        String normalizedStringKey = stringArgument.toLowerCase();
        return globalStateMap.get(normalizedStringKey);
    }

    public static globalPvPState getPvPGlobalState() {
        return globalState;
    }

    public static void setPvPGlobalState(globalPvPState globalState) {
        PvPToggleCore.globalState = globalState;
    }

    private static void removeIfExpired(Map<UUID, Long> pvpMap) {
        Iterator<UUID> iterator = pvpMap.keySet().iterator();
        while (iterator.hasNext()) {
            UUID playerUuid = iterator.next();
            long expiration = pvpMap.get(playerUuid);
            if (System.currentTimeMillis() < expiration) continue;
            iterator.remove();
        }
    }

    public static int getRemainingTimeout(class_3222 serverPlayer) {
        return PvPToggleCore.getRemainingTime(serverPlayer, timedOutPlayers);
    }

    public static int getRemainingCooldown(class_3222 serverPlayer) {
        return PvPToggleCore.getRemainingTime(serverPlayer, playersOnCooldown);
    }

    public static int getRemainingFlag(class_3222 serverPlayer) {
        return PvPToggleCore.getRemainingTime(serverPlayer, combatFlaggedPlayers);
    }

    private static int getRemainingTime(class_3222 serverPlayer, Map<UUID, Long> pvpMap) {
        UUID playerUuid = serverPlayer.method_5667();
        if (!pvpMap.containsKey(playerUuid)) {
            return 0;
        }
        return (int)((float)(pvpMap.get(playerUuid) - System.currentTimeMillis()) / 1000.0f);
    }

    static {
        globalStateMap.put("on", globalPvPState.ON);
        globalStateMap.put("off", globalPvPState.OFF);
        globalStateMap.put("neutral", globalPvPState.NEUTRAL);
    }

    public static enum playerState {
        NORMAL,
        COOLDOWN,
        FLAGGED,
        TIMED_OUT;

    }

    public static enum globalPvPState {
        ON,
        OFF,
        NEUTRAL;

    }
}

