/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import vilantious.pvptoggle.PvPToggle;
import vilantious.pvptoggle.PvPToggleCore;
import vilantious.pvptoggle.util.FeedbackHelper;
import vilantious.pvptoggle.util.TextBuilderUtil;

public class PvPCommand {
    private static final boolean SHOULD_BROADCAST = PvPToggle.PVP_TOGGLE_CONFIG.broadcastToOtherOps;
    private static final SimpleCommandExceptionType INVALID_GLOBAL_STATE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"pvptoggle.error.invalid_global_state"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pvp").executes(PvPCommand::toggleSelfPvPCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(PvPCommand::toggleOtherPvPSubCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"global").requires(serverCommandSource -> serverCommandSource.method_9259(4))).then(class_2170.method_9244((String)"global_toggle", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (PvPToggleCore.globalPvPState state : PvPToggleCore.globalPvPState.values()) {
                builder.suggest(String.valueOf((Object)state).toLowerCase());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"shouldBroadcast", (ArgumentType)BoolArgumentType.bool()).executes(PvPCommand::globalPvPStateSubCommand))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"status").executes(PvPCommand::pvpStatusSubCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(PvPCommand::pvpOtherStatusSubCommand))));
    }

    private static int toggleSelfPvPCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        boolean playerCooldown = PvPToggleCore.isPlayerOnCooldown(sourcePlayer);
        boolean playerFlag = PvPToggleCore.isPlayerFlagged(sourcePlayer);
        if (!playerCooldown && !playerFlag) {
            if (!sourcePlayer.method_68878()) {
                PvPToggleCore.putPlayerOnCooldown(sourcePlayer);
            }
            boolean pvpToggleSwitch = PvPToggleCore.togglePvP(sourcePlayer);
            class_5250 toggleSwitch = TextBuilderUtil.construct("pvptoggle.switch");
            class_5250 toggle = TextBuilderUtil.constructToggleSwitch(pvpToggleSwitch, false);
            sourcePlayer.method_7353((class_2561)toggleSwitch.method_10852((class_2561)toggle), true);
        } else if (playerFlag) {
            ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.construct("pvptoggle.toggle.flagged", TextBuilderUtil.FORMAT_RED_ALERT), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> TextBuilderUtil.construct("pvptoggle.toggle.cooldown", TextBuilderUtil.FORMAT_RED_ALERT), false);
        }
        class_3414 soundEvent = FeedbackHelper.fetchFeedbackSound(playerFlag, playerCooldown);
        sourcePlayer.method_17356(soundEvent, class_3419.field_15248, 1.0f, 1.0f + sourcePlayer.method_59922().method_43057());
        return 1;
    }

    private static int toggleOtherPvPSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        boolean pvpToggleSwitch = PvPToggleCore.togglePvP(otherPlayer);
        class_5250 pvpTogglePrefixOP = TextBuilderUtil.constructPvPTogglePrefix(true);
        class_5250 toggle = TextBuilderUtil.constructToggleSwitch(pvpToggleSwitch, false);
        class_5250 noSuffixToggle = TextBuilderUtil.constructToggleSwitch(pvpToggleSwitch, true);
        class_5250 switchOther = TextBuilderUtil.construct("pvptoggle.switch.other");
        class_5250 switchOtherPrefix = TextBuilderUtil.construct("pvptoggle.switch.other.prefix");
        class_5250 switchOtherSuffix = TextBuilderUtil.construct("pvptoggle.switch.other.suffix", otherPlayer.method_5476());
        ((class_2168)context.getSource()).method_9226(() -> pvpTogglePrefixOP.method_10852((class_2561)switchOtherPrefix).method_10852((class_2561)noSuffixToggle).method_10852((class_2561)switchOtherSuffix), SHOULD_BROADCAST);
        otherPlayer.method_7353((class_2561)switchOther.method_10852((class_2561)toggle), true);
        otherPlayer.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15248, 1.0f, 0.8f + otherPlayer.method_51469().method_8409().method_43057());
        return 1;
    }

    private static int globalPvPStateSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)context.getSource();
        String globalStateArgument = StringArgumentType.getString(context, (String)"global_toggle");
        boolean shouldBroadcastArgument = BoolArgumentType.getBool(context, (String)"shouldBroadcast");
        PvPToggleCore.globalPvPState currentGlobalState = PvPToggleCore.getPvPGlobalState();
        PvPToggleCore.globalPvPState newGlobalState = PvPToggleCore.tryFetchNewGlobalState(globalStateArgument, INVALID_GLOBAL_STATE);
        class_5250 pvpTogglePrefixOP = TextBuilderUtil.constructPvPTogglePrefix(true);
        class_5250 pvpTogglePrefix = TextBuilderUtil.constructPvPTogglePrefix(false);
        class_5250 alreadySetText = TextBuilderUtil.construct("pvptoggle.switch.global.already_set");
        if (currentGlobalState == newGlobalState) {
            serverCommandSource.method_9226(() -> pvpTogglePrefixOP.method_10852((class_2561)alreadySetText), SHOULD_BROADCAST);
            return 1;
        }
        PvPToggleCore.setPvPGlobalState(newGlobalState);
        class_5250 globalState = TextBuilderUtil.constructGlobalStateText(newGlobalState);
        class_5250 pvpStateGlobal = pvpTogglePrefix.method_10852((class_2561)globalState);
        if (shouldBroadcastArgument) {
            FeedbackHelper.sendGlobalFeedback(serverCommandSource.method_9225().method_18456(), (class_2561)pvpStateGlobal, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 0.8f + 0.2f * serverCommandSource.method_9225().method_8409().method_43057(), true);
        }
        return 1;
    }

    private static int pvpStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        boolean isPvpToggled = PvPToggleCore.isPvPToggled(sourcePlayer);
        class_5250 toggle = TextBuilderUtil.constructToggleSwitch(isPvpToggled, false);
        class_5250 status = TextBuilderUtil.construct("pvptoggle.status");
        sourcePlayer.method_7353((class_2561)status.method_10852((class_2561)toggle), true);
        return 1;
    }

    private static int pvpOtherStatusSubCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 otherPlayer = class_2186.method_9315(context, (String)"player");
        boolean isPvpToggled = PvPToggleCore.isPvPToggled(otherPlayer);
        class_5250 pvpTogglePrefix = TextBuilderUtil.constructPvPTogglePrefix(true);
        class_5250 toggle = TextBuilderUtil.constructToggleSwitch(isPvpToggled, true);
        class_5250 status = TextBuilderUtil.construct("pvptoggle.status");
        class_5250 suffixOther = TextBuilderUtil.construct("pvptoggle.switch.other.suffix", otherPlayer.method_5476());
        ((class_2168)context.getSource()).method_9226(() -> pvpTogglePrefix.method_10852((class_2561)status).method_10852((class_2561)toggle).method_10852((class_2561)suffixOther), SHOULD_BROADCAST);
        return 1;
    }
}

