/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import vilantious.pvptoggle.PvPToggle;

public class PvPToggleCore {
    private static final Map<UUID, Long> toggleCooldown = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> combatFlag = new HashMap<UUID, Long>();
    private static globalPvPState globalState = globalPvPState.DEFAULT_STATE;
    private static final Map<String, globalPvPState> globalStateMap = new HashMap<String, globalPvPState>();

    public static boolean togglePvP(class_3222 serverPlayer) {
        boolean currentValue = (Boolean)serverPlayer.getAttachedOrCreate(PvPToggle.PVP_TOGGLE_ATTACHMENT);
        boolean newValue = !currentValue;
        serverPlayer.setAttached(PvPToggle.PVP_TOGGLE_ATTACHMENT, (Object)newValue);
        return (Boolean)serverPlayer.getAttachedOrThrow(PvPToggle.PVP_TOGGLE_ATTACHMENT);
    }

    public static boolean isPvPToggled(class_3222 serverPlayer) {
        return (Boolean)serverPlayer.getAttachedOrCreate(PvPToggle.PVP_TOGGLE_ATTACHMENT);
    }

    public static void putPlayerOnCooldown(class_3222 serverPlayer) {
        UUID playerUuid = serverPlayer.method_5667();
        long time = serverPlayer.method_37908().method_8510();
        if (!toggleCooldown.containsKey(playerUuid)) {
            toggleCooldown.put(playerUuid, time);
        }
    }

    public static void flagPlayer(class_3222 serverPlayer) {
        PvPToggleCore.flagPlayers(new class_3222[]{serverPlayer});
    }

    public static void flagPlayers(class_3222[] participants) {
        for (class_3222 participant : participants) {
            UUID playerUuid = participant.method_5667();
            long time = participant.method_37908().method_8510();
            combatFlag.put(playerUuid, time);
        }
    }

    public static void queryPlayerFlag(class_3218 serverWorld) {
        PvPToggleCore.removeIfExpired(serverWorld, combatFlag, PvPToggle.PVP_TOGGLE_CONFIG.combatFlagDuration);
    }

    public static void queryPlayerCooldown(class_3218 serverWorld) {
        PvPToggleCore.removeIfExpired(serverWorld, toggleCooldown, PvPToggle.PVP_TOGGLE_CONFIG.toggleCooldown);
    }

    public static boolean isPlayerOnCooldown(class_3222 serverPlayer) {
        return toggleCooldown.containsKey(serverPlayer.method_5667());
    }

    public static boolean isPlayerFlagged(class_3222 serverPlayer) {
        return combatFlag.containsKey(serverPlayer.method_5667());
    }

    public static boolean maybePunishCombatLog(class_3222 serverPlayer) {
        if (!PvPToggleCore.isPlayerFlagged(serverPlayer)) {
            return false;
        }
        if (!PvPToggle.PVP_TOGGLE_CONFIG.punishCombatLog) {
            return false;
        }
        serverPlayer.method_5768(serverPlayer.method_51469());
        return true;
    }

    public static void clearFlagOnKilled(class_3222 serverPlayer) {
        if (PvPToggleCore.isPlayerFlagged(serverPlayer)) {
            combatFlag.remove(serverPlayer.method_5667());
        }
    }

    public static boolean isNotSelfDamage(class_3222 attacker, class_3222 victim) {
        return !attacker.method_5667().equals(victim.method_5667());
    }

    public static boolean isNotValidTameable(class_1309 entity, class_3222 serverPlayer) {
        if (!PvPToggle.PVP_TOGGLE_CONFIG.protectTameables) {
            return true;
        }
        if (entity instanceof class_6025) {
            class_6025 tameable = (class_6025)entity;
            if (tameable.method_66287() == null) {
                return true;
            }
            return serverPlayer == tameable.method_35057();
        }
        return true;
    }

    public static globalPvPState tryFetchNewGlobalState(String stringArgument, SimpleCommandExceptionType e) throws CommandSyntaxException {
        String normalizedStringKey = stringArgument.toLowerCase();
        if (!globalStateMap.containsKey(normalizedStringKey)) {
            throw e.create();
        }
        return globalStateMap.get(normalizedStringKey);
    }

    public static globalPvPState getPvPGlobalState() {
        return globalState;
    }

    public static void setPvPGlobalState(globalPvPState globalState) {
        PvPToggleCore.globalState = globalState;
    }

    public static void removeIfExpired(class_3218 serverWorld, Map<UUID, Long> pvpMap, int cooldown) {
        Iterator<UUID> iterator = pvpMap.keySet().iterator();
        while (iterator.hasNext()) {
            long oldTime;
            UUID playerUuid = iterator.next();
            long currentTime = serverWorld.method_8510();
            long elapsed = currentTime - (oldTime = pvpMap.get(playerUuid).longValue());
            if (elapsed < (long)cooldown) continue;
            iterator.remove();
        }
    }

    static {
        globalStateMap.put("on", globalPvPState.ON);
        globalStateMap.put("off", globalPvPState.OFF);
        globalStateMap.put("default_state", globalPvPState.DEFAULT_STATE);
    }

    public static enum globalPvPState {
        ON,
        OFF,
        DEFAULT_STATE;

    }
}

