/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shaderfixer.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class Utils {
    public static final ResourceLocation shader_fix = new ResourceLocation("shaderfixer", "textures/shaders_workaround.png");

    public static void fix() {
        Minecraft.getMinecraft().renderEngine.bindTexture(shader_fix);
    }

    public static int getCurrentTextureID() {
        return GL11.glGetInteger((int)32873);
    }

    public static void bindTextureByID(int textureID) {
        GL11.glBindTexture((int)3553, (int)textureID);
    }

    public static class ProgramUtils {
        public static int GLGetCurrentProgram() {
            return GL11.glGetInteger((int)35725);
        }

        public static void GLUseDefaultProgram() {
            GL20.glUseProgram((int)0);
        }

        public static void GLUseProgram(int program) {
            GL20.glUseProgram((int)program);
        }
    }

    public static class BrightnessUtils {
        public static float lbx;
        public static float lby;

        public static void enableFullBrightnessSafe() {
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        }

        public static void enableFullBrightness() {
            lbx = OpenGlHelper.lastBrightnessX;
            lby = OpenGlHelper.lastBrightnessY;
            GL11.glPushAttrib((int)1);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        }

        public static void disableFullBrightness() {
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)lbx, (float)lby);
            GL11.glPopAttrib();
        }
    }
}

