/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shaderfixer.mixins.late.SIGNPIC;

import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.gui.GuiImage;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.render.CustomTileEntitySignRenderer;
import javax.annotation.Nonnull;
import javax.vecmath.Quat4f;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySignRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntitySign;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CustomTileEntitySignRenderer.class}, priority=999)
public class MixinCustomTileEntitySignRenderer
extends TileEntitySignRenderer {
    @Overwrite(remap=false)
    public void renderSignPictureBase(@Nonnull TileEntitySign tile, double x, double y, double z, float partialTicks, float opacity) {
        OpenGL.glPushAttrib((int)11761);
        Entry entry = EntryId.SignEntryId.fromTile((TileEntitySign)tile).entry();
        if (entry.isOutdated() && CurrentMode.instance.isState(CurrentMode.State.SEE)) {
            OpenGL.glDisable((int)2929);
        }
        if (entry.isValid()) {
            if (CurrentMode.instance.isState(CurrentMode.State.SEE)) {
                OpenGL.glPushAttrib((int)11761);
                WRenderer.startTexture();
                OpenGL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(opacity * ((Double)Config.getConfig().renderSeeOpacity.get()).floatValue()));
                super.func_147500_a(tile, x, y, z, partialTicks);
                OpenGL.glPopAttrib();
            }
            OpenGL.glPushMatrix();
            this.translateBase(tile, x, y, z);
            OpenGL.glDisable((int)2884);
            GuiImage gui = entry.getGui();
            gui.applyLight((float)tile.field_145851_c, (float)tile.field_145848_d, (float)tile.field_145849_e, this.getSignRotate(tile));
            gui.renderSignPicture(opacity, 1.0f, new RenderOption());
            OpenGL.glEnable((int)2884);
            OpenGL.glPopMatrix();
        } else {
            OpenGL.glPushAttrib((int)11761);
            if (opacity < 1.0f) {
                WRenderer.startTexture();
                OpenGL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            }
            super.func_147500_a(tile, x, y, z, partialTicks);
            OpenGL.glPopAttrib();
        }
        OpenGL.glEnable((int)2929);
        WRenderer.startTexture();
        OpenGL.glPopAttrib();
    }

    @Shadow(remap=false)
    public void translateBase(@Nonnull TileEntitySign tile, double x, double y, double z) {
        Block block = tile.func_145838_q();
        float f1 = 0.6666667f;
        if (block == Blocks.field_150472_an) {
            OpenGL.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            RotationData.RotationGL.glRotate((Quat4f)this.getSignRotate(tile));
        } else {
            OpenGL.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            RotationData.RotationGL.glRotate((Quat4f)this.getSignRotate(tile));
            OpenGL.glTranslatef((float)0.0f, (float)0.0f, (float)-0.4375f);
        }
    }

    @Shadow(remap=false)
    @Nonnull
    public Quat4f getSignRotate(@Nonnull TileEntitySign tile) {
        float f3;
        Block block = tile.func_145838_q();
        if (block == Blocks.field_150472_an) {
            float f2 = (float)tile.func_145832_p() * 360.0f / 16.0f;
            return RotationData.RotationMath.quatDeg((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        int j = tile.func_145832_p();
        switch (j) {
            case 2: {
                f3 = 180.0f;
                break;
            }
            default: {
                f3 = 0.0f;
                break;
            }
            case 4: {
                f3 = 90.0f;
                break;
            }
            case 5: {
                f3 = -90.0f;
            }
        }
        return RotationData.RotationMath.quatDeg((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

