/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shaderfixer;

import com.kotmatross.shaderfixer.config.ShaderFixerConfig;
import com.kotmatross.shaderfixer.proxy.CommonProxy;
import com.kotmatross.shaderfixer.utils.BuiltInResourcePack;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="shaderfixer", version="4.8", name="Shader Fixer", acceptedMinecraftVersions="1.7.10")
public class ShaderFixer {
    public static final Logger logger = LogManager.getLogger((String)"SHADER_FIXER");
    public static boolean IS_ANGELICA_PRESENT = false;
    public static boolean IS_HBM_NTM_PRESENT = false;
    @SidedProxy(clientSide="com.kotmatross.shaderfixer.proxy.ClientProxy", serverSide="com.kotmatross.shaderfixer.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void onConstruction(FMLConstructionEvent event) {
        if (Loader.isModLoaded((String)"rivalrebels") && !((ModContainer)Loader.instance().getIndexedModList().get("rivalrebels")).getVersion().contains(" fixed")) {
            throw new RuntimeException("You are using a version of Rival Rebels that is not compatible with ShaderFixer, please update to: https://github.com/kotmatross28729/Rival-Rebels-Mod/releases");
        }
        if (event.getSide() == Side.CLIENT && ShaderFixerConfig.OPTIFINE_CRASH && FMLClientHandler.instance().hasOptifine()) {
            logger.fatal("Detected Optifine, immediate crash");
            proxy.throwIncompatibleModException("Optifine is not supported by ShaderFixer", "Delete Optifine and use Angelica instead");
        }
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"angelica")) {
            IS_ANGELICA_PRESENT = true;
        }
        if (Loader.isModLoaded((String)"hbm")) {
            IS_HBM_NTM_PRESENT = true;
        }
        if (event.getSide() == Side.CLIENT && IS_HBM_NTM_PRESENT) {
            if (ShaderFixerConfig.NTM_TEXTURE_FIX) {
                logger.info("NTM_TEXTURE_FIX enabled, loading resource pack");
                BuiltInResourcePack.register("NTM_FIX");
            } else {
                logger.info("NTM_TEXTURE_FIX disabled, skip resource pack loading");
            }
        }
    }
}

