package com.kotmatross.shadersfixer.mixins.late.client.hbm.client;

import net.minecraft.tileentity.TileEntity;

import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.hbm.render.tileentity.RenderSmallReactor;
import com.kotmatross.shadersfixer.Utils;

@Mixin(value = RenderSmallReactor.class, priority = 999)
public class MixinRenderSmallReactor {

    @Unique
    public int shaders_fixer$program;

    @Inject(
        method = "func_147500_a",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/renderer/Tessellator;startDrawingQuads()V",
            ordinal = 0,
            shift = At.Shift.BEFORE))
    public void func_147500_aPR(TileEntity tileEntity, double x, double y, double z, float f, CallbackInfo ci) {
        GL11.glDepthMask(false);
        shaders_fixer$program = Utils.GLGetCurrentProgram();
        Utils.GLUseDefaultProgram();
    }

    @Inject(
        method = "func_147500_a",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/renderer/Tessellator;draw()I",
            ordinal = 0,
            shift = At.Shift.AFTER))
    public void func_147500_aPRE(TileEntity tileEntity, double x, double y, double z, float f, CallbackInfo ci) {
        Utils.GLUseProgram(shaders_fixer$program);
        GL11.glDepthMask(true);
    }

    @Inject(
        method = "func_147500_a",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/Tessellator;startDrawingQuads()V"))
    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f, CallbackInfo ci) {
        Utils.EnableFullBrightness();
        Utils.Fix();
    }
}
