/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shadersfixer;

import com.kotmatross.shadersfixer.ShadersFixer;
import net.coderbot.iris.gl.program.Program;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class Utils {
    public static final ResourceLocation shaders_fix = new ResourceLocation("shadersfixer", "textures/shaders_workaround.png");
    public static final ResourceLocation shaders_fix2 = new ResourceLocation("shadersfixer", "textures/LightingFix.png");
    public static int INT_2X16 = 65536;
    public static int INT_MAX = Integer.MAX_VALUE;
    public static int MAX_LIGHT_COORD = 0xF000F0;

    public static void Fix() {
        Minecraft.getMinecraft().renderEngine.bindTexture(shaders_fix);
    }

    public static void Fix2() {
        Minecraft.getMinecraft().renderEngine.bindTexture(shaders_fix2);
    }

    public static float GetLastBrightnessX() {
        return OpenGlHelper.lastBrightnessX;
    }

    public static float GetLastBrightnessY() {
        return OpenGlHelper.lastBrightnessY;
    }

    public static void DisableFullBrightness(float lbx, float lby) {
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)lbx, (float)lby);
    }

    public static void EnableFullBrightness() {
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)(MAX_LIGHT_COORD % INT_2X16), (float)(MAX_LIGHT_COORD / INT_2X16));
    }

    public static int GLGetCurrentProgram() {
        return GL11.glGetInteger((int)35725);
    }

    public static void GLUseDefaultProgram() {
        if (ShadersFixer.IS_ANGELICA_PRESENT) {
            Program.unbind();
        } else {
            GL20.glUseProgram((int)0);
        }
    }

    public static void GLUseProgram(int program) {
        GL20.glUseProgram((int)program);
    }
}

