/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shadersfixer.mixins.late.client.eln.client;

import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.lampsocket.LampSocketStandardObjRender;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LampSocketStandardObjRender.class}, priority=999)
public class MixinLampSocketStandardObjRender {
    @Shadow(remap=false)
    private Obj3D.Obj3DPart socket;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart socket_unlightable;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart socket_lightable;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart lampOn;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart lampOff;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart lightAlphaPlane;
    @Shadow(remap=false)
    private Obj3D.Obj3DPart lightAlphaPlaneNoDepth;
    @Shadow(remap=false)
    ResourceLocation tOn;
    @Shadow(remap=false)
    ResourceLocation tOff;
    @Shadow(remap=false)
    private boolean onOffModel;

    @Overwrite(remap=false)
    public void draw(LRDU front, float alphaZ, byte light, boolean hasBulb, int color, double distanceToPlayer) {
        float coeff;
        front.glRotateOnX();
        UtilsClient.disableCulling();
        Utils.setGlColorFromLamp((int)color);
        if (!this.onOffModel) {
            if (this.socket != null) {
                this.socket.draw();
            }
        } else {
            if (light > 8) {
                UtilsClient.bindTexture((ResourceLocation)this.tOn);
            } else {
                UtilsClient.bindTexture((ResourceLocation)this.tOff);
            }
            if (this.socket_unlightable != null) {
                this.socket_unlightable.drawNoBind();
            }
            if (light > 8) {
                UtilsClient.disableLight();
                float l = (float)light / 14.0f;
                if (this.socket_lightable != null) {
                    this.socket_lightable.drawNoBind();
                }
            }
            if (hasBulb) {
                if (light > 8) {
                    if (this.lampOn != null) {
                        this.lampOn.draw();
                    }
                } else if (this.lampOff != null) {
                    this.lampOff.draw();
                }
            }
            if (this.socket != null) {
                this.socket.drawNoBind();
            }
            if (light > 8) {
                UtilsClient.enableLight();
            }
        }
        UtilsClient.enableBlend();
        UtilsClient.disableLight();
        if (this.lightAlphaPlaneNoDepth != null && (coeff = 2.0f - (float)distanceToPlayer) > 0.0f && light > 0) {
            UtilsClient.enableCulling();
            UtilsClient.disableDepthTest();
            if ((double)((float)light * 0.06667f * coeff) < 0.1) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)light * 0.06667f * coeff));
            }
            this.lightAlphaPlaneNoDepth.draw();
            UtilsClient.enableDepthTest();
            UtilsClient.disableCulling();
        }
        if (this.lightAlphaPlane != null && light > 0) {
            if ((double)((float)light * 0.06667f) < 0.1) {
                GL11.glColor4f((float)1.0f, (float)0.98f, (float)0.92f, (float)0.1f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.98f, (float)0.92f, (float)((float)light * 0.06667f));
            }
            this.lightAlphaPlane.draw();
        }
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
        UtilsClient.enableCulling();
    }
}

