/*
 * Decompiled with CFR 0.152.
 */
package com.kotmatross.shaderfixer.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public abstract class BuiltInResourcePack
extends AbstractResourcePack {
    private static final Splitter entryNameSplitter = Splitter.on((char)'/').omitEmptyStrings().limit(5);
    private final String modid;
    private final String id;

    public static void register(String id) {
        BuiltInResourcePack rp = BuiltInResourcePack.of(Loader.instance().activeModContainer().getSource(), Loader.instance().activeModContainer().getModId(), id);
        BuiltInResourcePack.inject((IResourcePack)rp);
    }

    private static BuiltInResourcePack of(File file, String modid, String id) {
        if (file.isDirectory()) {
            return new BuiltInFolderResourcePack(file, modid, id);
        }
        return new BuiltInFileResourcePack(file, modid, id);
    }

    public BuiltInResourcePack(File file, String modid, String id) {
        super(file);
        this.modid = modid;
        this.id = id;
    }

    public String getPackName() {
        return this.modid + "/" + this.id;
    }

    public IMetadataSection getPackMetadata(IMetadataSerializer p_135058_1_, String p_135058_2_) {
        return null;
    }

    public BufferedImage getPackImage() {
        return null;
    }

    protected String getRootPath() {
        return "resourcepacks/" + this.id + "/";
    }

    protected void addNamespaceIfLowerCase(Set<String> set, String ns) {
        if (!ns.equals(ns.toLowerCase())) {
            this.logNameNotLowercase(ns);
        } else {
            set.add(ns);
        }
    }

    private static void inject(IResourcePack resourcePack) {
        List defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.getMinecraft(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(resourcePack);
        IResourceManager resMan = Minecraft.getMinecraft().getResourceManager();
        if (resMan instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resMan).reloadResourcePack(resourcePack);
        }
    }

    private static class BuiltInFolderResourcePack
    extends BuiltInResourcePack {
        public BuiltInFolderResourcePack(File file, String modid, String id) {
            super(file, modid, id);
        }

        public Set<String> getResourceDomains() {
            File[] files;
            HashSet<String> domains = new HashSet<String>();
            File assetsDir = new File(this.resourcePackFile, this.getRootPath() + "assets/");
            if (assetsDir.isDirectory() && (files = assetsDir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) != null) {
                for (File file : files) {
                    this.addNamespaceIfLowerCase(domains, file.getName());
                }
            }
            return domains;
        }

        protected InputStream getInputStreamByName(String name) throws IOException {
            return new BufferedInputStream(Files.newInputStream(new File(this.resourcePackFile, this.getRootPath() + "/" + name).toPath(), new OpenOption[0]));
        }

        protected boolean hasResourceName(String name) {
            return new File(this.resourcePackFile, this.getRootPath() + "/" + name).isFile();
        }
    }

    private static class BuiltInFileResourcePack
    extends BuiltInResourcePack {
        private final ZipFile zipFile;

        public BuiltInFileResourcePack(File file, String modid, String id) {
            super(file, modid, id);
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Set<String> getResourceDomains() {
            HashSet<String> domains = new HashSet<String>();
            Enumeration<? extends ZipEntry> en = this.zipFile.entries();
            while (en.hasMoreElements()) {
                ArrayList nameParts;
                ZipEntry entry = en.nextElement();
                if (!entry.getName().startsWith(this.getRootPath() + "assets/") || (nameParts = Lists.newArrayList((Iterable)entryNameSplitter.split((CharSequence)entry.getName()))).size() <= 3) continue;
                this.addNamespaceIfLowerCase(domains, (String)nameParts.get(3));
            }
            return domains;
        }

        protected InputStream getInputStreamByName(String name) throws IOException {
            return this.zipFile.getInputStream(this.zipFile.getEntry(this.getRootPath() + name));
        }

        protected boolean hasResourceName(String name) {
            return this.zipFile.getEntry(this.getRootPath() + name) != null;
        }
    }
}

