package com.kotmatross.shaderfixer.mixins.late.FISKHEROES.render.effect;

import java.util.function.Consumer;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.fiskmods.heroes.client.render.effect.Effect;
import com.fiskmods.heroes.client.render.effect.EffectTentacles;

@Mixin(value = EffectTentacles.class, priority = 999)
public abstract class MixinEffectTentacles implements Effect {

    // Avoid leak
    @Inject(method = "doRender", at = @At(value = "HEAD"), remap = false)
    private void doRender(Effect.Entry e, EntityLivingBase anchor, boolean isClientPlayer, boolean isFirstPerson,
        float partialTicks, CallbackInfo ci) {
        GL11.glPushAttrib(GL11.GL_DEPTH_BUFFER_BIT);
    }

    @Inject(method = "doRender", at = @At(value = "TAIL"), remap = false)
    private void doRender2(Effect.Entry e, EntityLivingBase anchor, boolean isClientPlayer, boolean isFirstPerson,
        float partialTicks, CallbackInfo ci) {
        GL11.glPopAttrib();
    }

    @Inject(method = "renderTentacle", at = @At(value = "HEAD"), remap = false)
    private static void renderTentacle(Consumer<Float> render, Vec3 src, Vec3 mid, Vec3 dst, float segLength,
        int segments, CallbackInfo ci) {
        if (!GL11.glGetBoolean(GL11.GL_DEPTH_WRITEMASK)) {
            // Nuh uh
            GL11.glDepthMask(true);
        }
    }

    // 8 KB (88.8%) of file weight ↓↓↓
    //
    // BEFORE ↓
    //
    // /:::::::::::.........................................................................................
    // /:::::::...+#-::.....................................................................................
    // /:::......*@@+======:................................................................................
    // /.......:%@@@++++++*++++=--:.........................................................................
    // /......:@@@@@+++++++++++++++==+++-:..................................................................
    // /+=::-@@@@@@@+++++++++++++++++*#****++=-:............................................................
    // /**#@@@@@@@@@+++++++++++++++++*#########**++-........................................................
    // /@@@@@@@@@@@@++++++++++++++++++##############+:......................................................
    // /@@@@@@@@@@@@++++++++++++++++++##############@#*++++...........................................
    // /@@@@@@@@@@@@++++++++++++++++++###############@@@@@%%**+===+#+.....................
    // /@@@@@@@@@@@@++++++++++++++++++*##############@@@@@@@@@@%#####%#-...
    // /======-=+++@+++++++++++++*++++*********######@@@@@@@@######%@@@@#*.
    // /=====--------------====+#########************@@@@@@%#####%@@@@@@@@%#=.
    // /====------------------##################*****#@@@@@%###@@@@@@@@@@@@@@#*+
    // /====----------------+####################****#@@@@@@#@@@@@@@@@@@@@@@@@@@%*-.
    // /===----------------#######################***%@@@@@@@@%@@@@@@@@@@@@@@@@@@@@*+.
    // /==----------------########################****%%%%%@@@@@@@@@@@@@@@@@@@@@@@@@@%+=+++++++++++++++=+++=
    // /==----------------+########################**********========@@@@@@@@@@@@@@@@@@@*==+++++++++++++++++
    // /@%%%+--------------######################************+======#%@@#######*******=====*=+++++++++++++++
    // /@@@@@@@@@@@@@@@@@%=#####################**************+=+%@@@@@@@#######*******=====%@++++++++++++++
    // /@@@@@@@@@@@@#%@@@@@%##################****************@@@@@@@@@@@@#######******+====+@%*++++++++++++
    // /@@@@@@@@@@@@##@@@@@@@@@@@@@##########@@@@@@@@@@@####*@@@@@@@@@@@@@%#######******+=====++++++++++++++
    // /@@@@@@@@@@@%##%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%####@@@@@@@@@@@@@@#######****%@%%@@%++++++++++++++
    // /@@@@@@@@@@@###%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%####@@@@@@@@@@@@@@@@@@@@@@@@@@@@#*+++++++++++++++
    // /@@@@@@@@@@@####@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@####%@@@@@@@@@@@@@@@@@@@@@@#**++++++++++++++++++
    // /@@@@@@@@@@@###############%%%%#####%@@@@@@@@%@@@@@@@%####@@@@@@@@@@@@@@@@%#**++**+++++++++*+++++++++
    // /@@@@@@@@@@@#################################+++@@@@@@######@@@@@@@@%#***++*****++**+**++*+++***+++*+
    // /@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#***+++**++****+*****+++++++++++++++*+
    // /@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#****+*****************++****+++++**+**+++++
    // /####%%%%%%%%%%%%%%%%%%%%%%%%%%%%*****************%%#**************+******+*****++++**++*****++++**++
    // /#####**######*****###********#***********#**********************+++**++********++****+++*+++++***++*
    //
    // AFTER ↓
    //
    // /----------------------------------------------------------------------------------------------------
    // /----------------------------------------------------------------------------------------------------
    // /------------------%@*+++==------------------------------------------------------------------:::-----
    // /----------------=@@@@#++++++++==-----------------------------------------------------------------:::
    // /++*+==---------*@@@@@@%++++++++++++++=------------------------------------------------------::::----
    // /***********+=#@@@@@@@@@@++++++++++++++++++++=--------------------------------:::::::::::::::::::::::
    // /#******************#%%@@@+++++++++++++++++++++++----------------::::::::::::::::::::::::::::::::::::
    // /*********************#@@@@#*++++++++++++++++++++++=-------::::::::::::::::::::::::::::::::::::::::::
    // /*********************@@@%#########**+++++++++++++++**+++=--:-=-:::::::::::::::::::::::::::::::::::::
    // /********************%@@%##########*########**+++++++*####**++**+-:::::::::::::::::::::::::::::::::::
    // /*******************#@@##############******########***+++++*#####**=-::::::::::::::::::::::::::::::::
    // /*******************@@%*********##%%%%%%%%%##******####*+++++++++*#*++-::::::::::::::::::::::::::::::
    // /******************%@@*********#%%%%%%%%%%%%%%%%%%%#**+++++++++++++*#**++-:::::::::::::::::::::::::::
    // /*****************%@@**********###%%%%%%%%%%%%%%%%%%%%%%%%%#**++++++*##**++=:::::::::::::::::::::::::
    // /****************#@@%*********************####%%%%%%%%%%%%%%%%%%%%##**##%#**++-::::::::::::::::::::::
    // /****************@@%********************************%%%%%%%%%%%%%%%%#%%%%%%%#**++++++++++++++++++++++
    // /***************%@@*+++******#*********************++***###%%%%%%##%%%%%%%%%%%%##++++++++++++++++++++
    // /**************#@@@*++++++++##***************+++++++++++++=====+#####%%%%%%%%%%%%%##+++++++++++++++++
    // /*************#@@@@+++++++++*#%#####*********+++++++++++++=======*#**********###%%%%%#+++++++++++++++
    // /*************%@@@%+++++++++***####%%%%%%%%%%%%%#####*****+=======+#***********++++++++++++++++++++++
    // /%@@@@@@%%%%%%@@@%%%%%%%########***+**************#%%%%%%%%%%%%%%%###**********##*##*++++++++++++++++
    // /*@@@@@@@@@@@@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%###%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#*++++++++++++++++++
    // /*#@@@@@@@@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%##*++++++++++++++++++++++
    // /**@@@@@@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%@@@@@@@@@@@@@@%%%%%%%%%%%%#**+++++++++++++++++++++++++++
    // /*#@@@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#############**%%%%%%%#**++++*++++++++++++++++++++++++++++
    // /*%@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*+*++++++**++*+*++*++++++*++*+++++++++++++
    // /********###****#################%%%**+*++**++***+**%#***++**++**+**++*+++++++++++**+++++++++++++++*+
    // /********************************************+****++*++*****+*++++++++++**+**++*+++++++++++*+++++++++
    // /*****************+***********+*************++**+*********+**+++++++*+**+++*+++*+++++++++**++++++++++

}
