/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.data;

import com.jahirtrap.healthindicator.data.BarState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BarStates {
    private static final Map<Integer, BarState> STATES = new HashMap<Integer, BarState>();
    private static int tickCount = 0;

    public static BarState getState(LivingEntity entity) {
        return STATES.computeIfAbsent(entity.m_19879_(), k -> new BarState(entity));
    }

    public static void tick() {
        for (BarState state : STATES.values()) {
            state.tick();
        }
        if (tickCount % 200 == 0) {
            BarStates.cleanCache();
        }
        ++tickCount;
    }

    private static void cleanCache() {
        STATES.entrySet().removeIf(BarStates::stateExpired);
    }

    private static boolean stateExpired(Map.Entry<Integer, BarState> entry) {
        if (entry.getValue() == null) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = null;
        if (minecraft.f_91073_ != null) {
            entity = minecraft.f_91073_.m_6815_(entry.getKey().intValue());
        }
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (!minecraft.f_91073_.m_46805_(entity.m_20183_())) {
            return true;
        }
        return !entity.m_6084_();
    }
}

