/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarRenderer;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BarDisplay {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft mc;
    private int infoWidth;

    public BarDisplay(Minecraft mc) {
        this.mc = mc;
    }

    public void draw(GuiGraphics guiGraphics, PoseStack poseStack, LivingEntity entity) {
        int barWidth = 128;
        int barHeight = 6;
        int xOffset = 1;
        int xOffsetM = 1;
        int yOffset = 2;
        if (ModConfig.barStyle == ModConfig.BarStyle.VANILLA) {
            barHeight = 5;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_TEXTURES);
        RenderSystem.enableBlend();
        int armorValue = entity.m_21230_();
        boolean armor = armorValue > 0;
        String name = entity.m_5446_().getString();
        float health = entity.m_21223_() + entity.m_6103_();
        float maxHealth = entity.m_21233_() + entity.m_6103_();
        String healthMax = String.valueOf(Mth.m_14167_((float)maxHealth));
        String healthCur = String.valueOf(Math.min(Mth.m_14167_((float)health), Integer.parseInt(healthMax)));
        if (ModConfig.showHealthDecimals) {
            healthMax = CommonUtils.formatText(maxHealth);
            healthCur = CommonUtils.formatText(Math.min(health, maxHealth));
        }
        Object healthText = healthCur + "/" + healthMax;
        String armorText = String.valueOf(armorValue);
        String modNameText = CommonUtils.getModName(entity);
        switch (ModConfig.healthTextFormat) {
            case CURRENT_HEALTH: {
                healthText = healthCur;
                break;
            }
            case MAX_HEALTH: {
                healthText = healthMax;
            }
        }
        boolean showName = ModConfig.showName;
        boolean showHealth = ModConfig.showHealth;
        boolean showArmor = ModConfig.showArmor;
        boolean showModName = ModConfig.showModName;
        boolean showBar = ModConfig.showBar;
        this.setInfoWidth(name, armor, (String)healthText, armorText);
        int offAux = this.getInfoWidth();
        int center = barWidth / 2 - offAux / 2;
        int right = barWidth - offAux - xOffset;
        int centerM = barWidth / 2 - this.mc.f_91062_.m_92895_(modNameText) / 2;
        int rightM = barWidth - this.mc.f_91062_.m_92895_(modNameText) - xOffsetM;
        switch (ModConfig.position) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                xOffset = center;
                xOffsetM = centerM;
                break;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                xOffset = right;
                xOffsetM = rightM;
            }
        }
        BarRenderer.render(poseStack, entity, barWidth, barHeight, armor, showBar, offAux, this.mc.f_91062_.m_92895_(modNameText), Math.min(xOffset, xOffsetM));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (showName && !name.isBlank()) {
            guiGraphics.m_280488_(this.mc.f_91062_, name, xOffset, yOffset, 0xFFFFFF);
            xOffset += this.mc.f_91062_.m_92895_(name) + 5;
        }
        if (showHealth) {
            this.renderHeartIcon(guiGraphics, xOffset, entity);
            guiGraphics.m_280488_(this.mc.f_91062_, (String)healthText, xOffset += 10, yOffset, 0xFFFFFF);
            xOffset += this.mc.f_91062_.m_92895_((String)healthText) + 5;
        }
        if (armor && showArmor) {
            this.renderArmorIcon(guiGraphics, xOffset);
            guiGraphics.m_280488_(this.mc.f_91062_, armorText, xOffset += 10, yOffset, 0xFFFFFF);
        }
        if (showModName && !modNameText.isBlank()) {
            yOffset = 15 + barHeight;
            if (offAux == 0) {
                yOffset -= 12;
            }
            if (!showBar) {
                yOffset -= barHeight + 2;
            }
            guiGraphics.m_280488_(this.mc.f_91062_, modNameText, xOffsetM, yOffset, CommonUtils.getColor(0x5555FF, ModConfig.modNameColor).intValue());
        }
    }

    private void renderArmorIcon(GuiGraphics guiGraphics, int x) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_TEXTURES);
        guiGraphics.m_280218_(ICON_TEXTURES, x, 1, 34, 9, 9, 9);
    }

    private void renderHeartIcon(GuiGraphics guiGraphics, int x, LivingEntity entity) {
        int u = 52;
        int v = 0;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_TEXTURES);
        guiGraphics.m_280218_(ICON_TEXTURES, x, 1, 16, 0, 9, 9);
        if (ModConfig.dynamicHeartTexture) {
            if (entity instanceof Player && this.mc.f_91073_ != null && this.mc.f_91073_.m_6106_().m_5466_()) {
                v = 45;
            }
            if (entity.m_146888_() >= entity.m_146891_()) {
                u = 178;
            } else if (entity.m_6103_() > 0.0f) {
                u = 160;
            }
        }
        guiGraphics.m_280218_(ICON_TEXTURES, x, 1, u, v, 9, 9);
    }

    public void setInfoWidth(String name, boolean armor, String healthText, String armorText) {
        int infoWidth = 0;
        boolean aux = true;
        if (ModConfig.showName && !name.isBlank()) {
            infoWidth += this.mc.f_91062_.m_92895_(name);
            if (ModConfig.showHealth) {
                infoWidth += 5;
                aux = false;
            }
            if (armor && ModConfig.showArmor) {
                infoWidth += 5;
            }
        }
        if (ModConfig.showHealth) {
            infoWidth += this.mc.f_91062_.m_92895_(healthText) + 10;
            if (armor && ModConfig.showArmor && aux) {
                infoWidth += 5;
            }
        }
        if (armor && ModConfig.showArmor) {
            infoWidth += this.mc.f_91062_.m_92895_(armorText) + 10;
        }
        this.infoWidth = infoWidth;
    }

    public int getInfoWidth() {
        return this.infoWidth;
    }
}

