/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.data.BarState;
import com.jahirtrap.healthindicator.data.BarStates;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class BarRenderer {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("healthindicatortxf", "textures/gui/bars.png");

    public static void render(PoseStack poseStack, LivingEntity entity, int width, int height, boolean armor, boolean bar, int wVal1, int wVal2, int oVal1) {
        CommonUtils.EntityType entityType = CommonUtils.getEntityType((Entity)entity);
        int color = 0x8000FF;
        int color2 = 0x400080;
        int color3 = 0x808080;
        int color4 = 0;
        int alpha4 = 0;
        if (entityType == CommonUtils.EntityType.PASSIVE) {
            color = CommonUtils.getColor(65280, ModConfig.passiveColor);
            color2 = CommonUtils.getColor(32768, ModConfig.passiveColorSecondary);
        } else if (entityType == CommonUtils.EntityType.HOSTILE) {
            color = CommonUtils.getColor(0xFF0000, ModConfig.hostileColor);
            color2 = CommonUtils.getColor(0x800000, ModConfig.hostileColorSecondary);
        } else if (entityType == CommonUtils.EntityType.NEUTRAL) {
            color = CommonUtils.getColor(255, ModConfig.neutralColor);
            color2 = CommonUtils.getColor(128, ModConfig.neutralColorSecondary);
        }
        color3 = CommonUtils.getColor(0x808080, ModConfig.backgroundBarColor);
        color4 = CommonUtils.getColor(0, ModConfig.hudBackgroundColor);
        alpha4 = ModConfig.hudBackgroundOpacity;
        BarState state = BarStates.getState(entity);
        float percent = Math.min(1.0f, Math.min(state.health, entity.m_21233_()) / entity.m_21233_());
        float percent2 = Math.min(state.previousHealthDisplay, entity.m_21233_()) / entity.m_21233_();
        int zOffset = 0;
        Matrix4f m4f = poseStack.m_85850_().m_252922_();
        if (!bar) {
            width = 0;
        }
        if (alpha4 > 0) {
            if (width >= wVal1 && width >= wVal2) {
                oVal1 = 0;
            }
            BarRenderer.drawBackground(m4f, color4, alpha4, zOffset++, wVal1, Math.max(Math.max(width, wVal1), wVal2), oVal1);
        }
        if (!bar) {
            return;
        }
        if (ModConfig.showBackgroundBar) {
            BarRenderer.drawBar(m4f, width, height, 1.0f, color3, zOffset++, true, armor);
        }
        if (ModConfig.showSecondaryBar) {
            BarRenderer.drawBar(m4f, width, height, percent2, color2, zOffset++, false, armor);
        }
        BarRenderer.drawBar(m4f, width, height, percent, color, zOffset, false, armor);
    }

    private static void drawBar(Matrix4f matrix4f, int width, int height, float percent, int color, int zOffset, boolean back, boolean armor) {
        float v = 10.0f;
        switch (ModConfig.barStyle) {
            case VANILLA: {
                v -= (float)height;
                break;
            }
            case DEFAULT: {
                v += (float)height;
                break;
            }
            case ROUNDED: {
                v += (float)(height * 3);
                break;
            }
            case GRADIENT: {
                v += (float)(height * 5);
                break;
            }
            case MINIMALIST: {
                v += (float)(height * 7);
                break;
            }
            case MODERN: {
                v += (float)(height * 9);
            }
        }
        float c = 0.0078125f;
        float u = 0.0f;
        if (back) {
            v -= (float)height;
        }
        int uw = Mth.m_14167_((float)(128.0f * percent));
        int y = 12;
        if (!(ModConfig.showName || ModConfig.showHealth || armor && ModConfig.showArmor)) {
            y = 0;
        }
        float size = percent * (float)width;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_TEXTURES);
        RenderSystem.enableBlend();
        float zOffsetAmount = 0.1f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix4f, 0.0f, (float)y, (float)zOffset * zOffsetAmount).m_7421_(u * c, v * c).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, (float)(y + height), (float)zOffset * zOffsetAmount).m_7421_(u * c, (v + (float)height) * c).m_5752_();
        buffer.m_252986_(matrix4f, size, (float)(y + height), (float)zOffset * zOffsetAmount).m_7421_((u + (float)uw) * c, (v + (float)height) * c).m_5752_();
        buffer.m_252986_(matrix4f, size, (float)y, (float)zOffset * zOffsetAmount).m_7421_((u + (float)uw) * c, v * c).m_5752_();
        tesselator.m_85914_();
    }

    private static void drawBackground(Matrix4f matrix4f, int color, int alpha, int zOffset, int wVal1, int maxWidth, int minOffset) {
        int padding = 3;
        int xw = maxWidth + minOffset + padding;
        int yh = CommonUtils.getHudHeight(wVal1) + 1 + padding;
        int x = minOffset - padding;
        int y = 1 - padding;
        switch (ModConfig.position) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                --x;
                break;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                ++xw;
            }
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)((float)alpha / 100.0f));
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.enableBlend();
        float zOffsetAmount = 0.1f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_252986_(matrix4f, (float)x, (float)y, (float)zOffset * zOffsetAmount).m_5752_();
        buffer.m_252986_(matrix4f, (float)x, (float)(y + yh), (float)zOffset * zOffsetAmount).m_5752_();
        buffer.m_252986_(matrix4f, (float)xw, (float)(y + yh), (float)zOffset * zOffsetAmount).m_5752_();
        buffer.m_252986_(matrix4f, (float)xw, (float)y, (float)zOffset * zOffsetAmount).m_5752_();
        tesselator.m_85914_();
    }
}

