/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarDisplay;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.Tags;

public class Hud
extends Screen {
    private final BarDisplay barDisplay;
    private LivingEntity entity;
    private int age;

    public Hud() {
        super((Component)Component.m_237119_());
        this.f_96541_ = Minecraft.m_91087_();
        this.barDisplay = new BarDisplay(this.f_96541_);
    }

    public void draw(GuiGraphics guiGraphics) {
        if (this.f_96541_ != null && (this.f_96541_.f_91066_.f_92063_ || this.f_96541_.f_91066_.f_92062_)) {
            return;
        }
        float scale = (float)ModConfig.scale;
        float x = this.determineX();
        float y = this.determineY();
        this.draw(guiGraphics, guiGraphics.m_280168_(), x, y, scale);
    }

    private float determineX() {
        float scale = (float)ModConfig.scale;
        float barWidth = (float)CommonUtils.getHudWidth() * scale;
        float x = (float)ModConfig.xValue;
        ModConfig.Position position = ModConfig.position;
        float wScreen = 0.0f;
        if (this.f_96541_ != null) {
            wScreen = this.f_96541_.m_91268_().m_85445_();
        }
        float xV = x + 3.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.TOP_CENTER -> wScreen / 2.0f + x - barWidth / 2.0f;
            case ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.TOP_RIGHT -> wScreen - xV - barWidth;
            default -> xV;
        };
    }

    private float determineY() {
        float scale = (float)ModConfig.scale;
        float barHeight = (float)CommonUtils.getHudHeight(this.barDisplay.getInfoWidth()) * scale;
        float y = (float)ModConfig.yValue;
        ModConfig.Position position = ModConfig.position;
        float hScreen = 0.0f;
        if (this.f_96541_ != null) {
            hScreen = this.f_96541_.m_91268_().m_85446_();
        }
        float yV = y + 2.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.BOTTOM_LEFT -> hScreen - yV - barHeight;
            default -> yV;
        };
    }

    public void m_86600_() {
        ++this.age;
    }

    private void setEntityWork(LivingEntity entity) {
        this.entity = entity;
    }

    public void setEntity(LivingEntity entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > ModConfig.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && !ModConfig.showInvisibleEntities && entity.m_20145_() && !entity.m_142038_() && !entity.m_6060_()) {
            this.setEntityWork(null);
        } else if (entity != null && !ModConfig.showBosses && entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
            this.setEntityWork(null);
        } else if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void draw(GuiGraphics guiGraphics, PoseStack poseStack, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        if (!(ModConfig.showName || ModConfig.showHealth || ModConfig.showArmor || ModConfig.showBar || ModConfig.showModName)) {
            return;
        }
        if (CommonUtils.checkBlacklist(ModConfig.blacklist, this.entity) || CommonUtils.checkBlacklist(ModConfig.barBlacklist, this.entity)) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        if (ModConfig.enableMod && ModConfig.showHud) {
            this.barDisplay.draw(guiGraphics, poseStack, this.entity);
        }
        poseStack.m_85849_();
    }
}

