/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ParticleRenderer
extends Particle {
    private String text;
    private double particleScale;
    private Double animationMinSize;
    private Double animationMaxSize;
    private Boolean animationFade;

    public ParticleRenderer(ClientLevel clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void m_107271_(float alpha) {
        this.f_107230_ = alpha;
    }

    public void setColor(int color) {
        this.f_107227_ = CommonUtils.getRedFromColor(color);
        this.f_107228_ = CommonUtils.getGreenFromColor(color);
        this.f_107229_ = CommonUtils.getBlueFromColor(color);
    }

    public void setAnimationSize(double min, double max) {
        this.animationMinSize = min;
        this.animationMaxSize = max;
    }

    public void setAnimationFade(boolean animationFade) {
        this.animationFade = animationFade;
    }

    public void m_5744_(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTicks) {
        if (this.text == null || this.text.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = camera.m_90583_();
        float particleX = (float)(this.f_107209_ + (this.f_107212_ - this.f_107209_) * (double)partialTicks - cameraPos.m_7096_());
        float particleY = (float)(this.f_107210_ + (this.f_107213_ - this.f_107210_) * (double)partialTicks - cameraPos.m_7098_());
        float particleZ = (float)(this.f_107211_ + (this.f_107214_ - this.f_107211_) * (double)partialTicks - cameraPos.m_7094_());
        float textX = -mc.f_91062_.m_92895_(this.text) / 2;
        float textY = 0.0f;
        int textColor = CommonUtils.getColorFromRGBA(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
        int shadowColor = CommonUtils.getColorFromRGBA(this.f_107227_ * 0.314f, this.f_107228_ * 0.314f, this.f_107229_ * 0.314f, this.f_107230_);
        this.animateSize(partialTicks);
        this.animateFade(partialTicks);
        if (this.f_107230_ == 0.0f) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(particleX, particleY, particleZ);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-0.024f, -0.024f, 0.024f);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        if (this.particleScale != 0.0) {
            poseStack.m_85841_((float)this.particleScale, (float)this.particleScale, 1.0f);
        }
        poseStack.m_252880_(0.0f, 0.0f, 1.0f);
        mc.f_91062_.m_271703_(this.text, textX, textY, shadowColor, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_252880_(0.0f, 0.0f, -2.0f);
        mc.f_91062_.m_271703_(this.text, textX, textY, textColor, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_252880_(0.0f, 0.0f, 1.0f);
        poseStack.m_85849_();
        buffer.m_109911_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void animateSize(float partialTicks) {
        if (this.animationMinSize == null || this.animationMaxSize == null) {
            return;
        }
        double d1 = 6.0 * (double)((float)(this.f_107224_ - 1) + partialTicks) / (double)this.f_107225_ * (this.animationMaxSize - this.animationMinSize) - this.animationMaxSize + this.animationMinSize;
        double d2 = -3.0 * (double)((float)(this.f_107224_ - 1) + partialTicks) / (double)this.f_107225_ * (this.animationMaxSize - this.animationMinSize) + 2.5 * this.animationMaxSize - 2.5 * this.animationMinSize;
        double d3 = -(d1 + Math.abs(d1)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        double d4 = -(d2 + Math.abs(d2)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        this.particleScale = -(d3 + Math.abs(d3) + d4 + Math.abs(d4)) / 4.0 + this.animationMaxSize;
    }

    public void animateFade(float partialTicks) {
        if (!this.animationFade.booleanValue()) {
            return;
        }
        double d1 = (double)((float)this.f_107225_ - ((float)(this.f_107224_ - 1) + partialTicks)) + (double)this.f_107225_ / 6.0;
        double d2 = (double)((float)this.f_107225_ - ((float)(this.f_107224_ - 1) + partialTicks)) - (double)this.f_107225_ / 6.0;
        this.f_107230_ = (float)((d1 - Math.abs(d2)) / ((double)this.f_107225_ / 3.0));
    }

    public static class DamageParticle
    extends ParticleRenderer {
        public DamageParticle(ClientLevel clientLevel, double x, double y, double z) {
            super(clientLevel, x, y, z);
            this.m_5989_();
        }

        public void m_5989_() {
            if (this.f_107224_++ >= this.f_107225_) {
                this.m_107274_();
                return;
            }
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.f_107216_ = 0.12 * (2.0 * (double)(this.f_107224_ - 1) - (double)this.f_107225_) * (2.0 * (double)(this.f_107224_ - 1) - (double)this.f_107225_) / (double)(this.f_107225_ * this.f_107225_);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }
}

