/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarRenderer;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BarDisplay {
    private static final ResourceLocation ARMOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    private static final ResourceLocation HEART_CONTAINER_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/container");
    private static final ResourceLocation HEART_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
    private final Minecraft mc;
    private int infoWidth;

    public BarDisplay(Minecraft mc) {
        this.mc = mc;
    }

    public void draw(GuiGraphics guiGraphics, PoseStack poseStack, LivingEntity entity) {
        int armorValue;
        int barWidth = 128;
        int barHeight = 6;
        int xOffset = 1;
        int xOffsetM = 1;
        int yOffset = 2;
        if (ModConfig.barStyle == ModConfig.BarStyle.VANILLA) {
            barHeight = 5;
        }
        boolean armor = (armorValue = entity.getArmorValue()) > 0;
        String name = entity.getDisplayName().getString();
        float health = entity.getHealth() + entity.getAbsorptionAmount();
        float maxHealth = entity.getMaxHealth() + entity.getAbsorptionAmount();
        String healthMax = String.valueOf(Mth.ceil((float)maxHealth));
        String healthCur = String.valueOf(Math.min(Mth.ceil((float)health), Integer.parseInt(healthMax)));
        if (ModConfig.showHealthDecimals) {
            healthMax = CommonUtils.formatText(maxHealth);
            healthCur = CommonUtils.formatText(Math.min(health, maxHealth));
        }
        Object healthText = healthCur + "/" + healthMax;
        String armorText = String.valueOf(armorValue);
        String modNameText = CommonUtils.getModName(entity);
        switch (ModConfig.healthTextFormat) {
            case CURRENT_HEALTH: {
                healthText = healthCur;
                break;
            }
            case MAX_HEALTH: {
                healthText = healthMax;
            }
        }
        boolean showName = ModConfig.showName;
        boolean showHealth = ModConfig.showHealth;
        boolean showArmor = ModConfig.showArmor;
        boolean showModName = ModConfig.showModName;
        boolean showBar = ModConfig.showBar;
        this.setInfoWidth(name, armor, (String)healthText, armorText);
        int offAux = this.getInfoWidth();
        int center = barWidth / 2 - offAux / 2;
        int right = barWidth - offAux - xOffset;
        int centerM = barWidth / 2 - this.mc.font.width(modNameText) / 2;
        int rightM = barWidth - this.mc.font.width(modNameText) - xOffsetM;
        switch (ModConfig.position) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                xOffset = center;
                xOffsetM = centerM;
                break;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                xOffset = right;
                xOffsetM = rightM;
            }
        }
        BarRenderer.render(poseStack, entity, barWidth, barHeight, armor, showBar, offAux, this.mc.font.width(modNameText), Math.min(xOffset, xOffsetM));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (showName && !name.isBlank()) {
            guiGraphics.drawString(this.mc.font, name, xOffset, yOffset, 0xFFFFFF);
            xOffset += this.mc.font.width(name) + 5;
        }
        if (showHealth) {
            this.renderHeartIcon(guiGraphics, xOffset, entity);
            guiGraphics.drawString(this.mc.font, (String)healthText, xOffset += 10, yOffset, 0xFFFFFF);
            xOffset += this.mc.font.width((String)healthText) + 5;
        }
        if (armor && showArmor) {
            this.renderArmorIcon(guiGraphics, xOffset);
            guiGraphics.drawString(this.mc.font, armorText, xOffset += 10, yOffset, 0xFFFFFF);
        }
        if (showModName && !modNameText.isBlank()) {
            yOffset = 15 + barHeight;
            if (offAux == 0) {
                yOffset -= 12;
            }
            if (!showBar) {
                yOffset -= barHeight + 2;
            }
            guiGraphics.drawString(this.mc.font, modNameText, xOffsetM, yOffset, CommonUtils.getColor(0x5555FF, ModConfig.modNameColor).intValue());
        }
    }

    private void renderArmorIcon(GuiGraphics guiGraphics, int x) {
        guiGraphics.blitSprite(RenderType::guiTextured, ARMOR_FULL_SPRITE, x, 1, 9, 9);
    }

    private void renderHeartIcon(GuiGraphics guiGraphics, int x, LivingEntity entity) {
        ResourceLocation icon = HEART_FULL_SPRITE;
        guiGraphics.blitSprite(RenderType::guiTextured, HEART_CONTAINER_SPRITE, x, 1, 9, 9);
        if (ModConfig.dynamicHeartTexture) {
            icon = this.getHeartSprite(entity);
        }
        guiGraphics.blitSprite(RenderType::guiTextured, icon, x, 1, 9, 9);
    }

    private ResourceLocation getHeartSprite(LivingEntity entity) {
        ResourceLocation HEART_FROZEN_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_full");
        ResourceLocation HEART_ABSORBING_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_full");
        ResourceLocation HEART_X_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_full");
        ResourceLocation HEART_X_FROZEN_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_hardcore_full");
        ResourceLocation HEART_X_ABSORBING_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_hardcore_full");
        ResourceLocation icon = HEART_FULL_SPRITE;
        boolean hardcore = false;
        if (entity instanceof Player && this.mc.level != null && this.mc.level.getLevelData().isHardcore()) {
            hardcore = true;
            icon = HEART_X_FULL_SPRITE;
        }
        if (entity.getTicksFrozen() >= entity.getTicksRequiredToFreeze()) {
            icon = !hardcore ? HEART_FROZEN_FULL_SPRITE : HEART_X_FROZEN_FULL_SPRITE;
        } else if (entity.getAbsorptionAmount() > 0.0f) {
            icon = !hardcore ? HEART_ABSORBING_FULL_SPRITE : HEART_X_ABSORBING_FULL_SPRITE;
        }
        return icon;
    }

    public void setInfoWidth(String name, boolean armor, String healthText, String armorText) {
        int infoWidth = 0;
        boolean aux = true;
        if (ModConfig.showName && !name.isBlank()) {
            infoWidth += this.mc.font.width(name);
            if (ModConfig.showHealth) {
                infoWidth += 5;
                aux = false;
            }
            if (armor && ModConfig.showArmor) {
                infoWidth += 5;
            }
        }
        if (ModConfig.showHealth) {
            infoWidth += this.mc.font.width(healthText) + 10;
            if (armor && ModConfig.showArmor && aux) {
                infoWidth += 5;
            }
        }
        if (armor && ModConfig.showArmor) {
            infoWidth += this.mc.font.width(armorText) + 10;
        }
        this.infoWidth = infoWidth;
    }

    public int getInfoWidth() {
        return this.infoWidth;
    }
}

