/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ParticleRenderer
extends Particle {
    private String text;
    private double scale = 1.0;
    private double animationScale;
    private Double animationMinSize;
    private Double animationMaxSize;
    private Boolean animationFade;

    public ParticleRenderer(ClientLevel clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int color) {
        this.rCol = CommonUtils.getRedFromColor(color);
        this.gCol = CommonUtils.getGreenFromColor(color);
        this.bCol = CommonUtils.getBlueFromColor(color);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setAnimationSize(double min, double max) {
        this.animationMinSize = min;
        this.animationMaxSize = max;
    }

    public void setAnimationFade(boolean animationFade) {
        this.animationFade = animationFade;
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTicks) {
        if (this.text == null || this.text.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 cameraPos = camera.getPosition();
        float particleX = (float)(this.xo + (this.x - this.xo) * (double)partialTicks - cameraPos.x());
        float particleY = (float)(this.yo + (this.y - this.yo) * (double)partialTicks - cameraPos.y());
        float particleZ = (float)(this.zo + (this.z - this.zo) * (double)partialTicks - cameraPos.z());
        float textX = -mc.font.width(this.text) / 2;
        float textY = -mc.font.wordWrapHeight(this.text, 0);
        int textColor = CommonUtils.getColorFromRGBA(this.rCol, this.gCol, this.bCol, this.alpha);
        this.animateSize(partialTicks);
        this.animateFade(partialTicks);
        if (this.alpha == 0.0f) {
            return;
        }
        Matrix4f matrix = new Matrix4f();
        matrix = matrix.translate(particleX, particleY, particleZ);
        matrix = matrix.rotate((Quaternionfc)camera.rotation());
        matrix = matrix.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix = matrix.scale(-0.024f, -0.024f, -0.024f);
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        if (this.animationScale != 0.0) {
            matrix = matrix.scale((float)this.animationScale, (float)this.animationScale, 1.0f);
        }
        matrix = matrix.scale((float)this.scale, (float)this.scale, 1.0f);
        mc.font.drawInBatch(this.text, textX, textY, textColor, true, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void animateSize(float partialTicks) {
        if (this.animationMinSize == null || this.animationMaxSize == null) {
            return;
        }
        double d1 = 6.0 * (double)((float)(this.age - 1) + partialTicks) / (double)this.lifetime * (this.animationMaxSize - this.animationMinSize) - this.animationMaxSize + this.animationMinSize;
        double d2 = -3.0 * (double)((float)(this.age - 1) + partialTicks) / (double)this.lifetime * (this.animationMaxSize - this.animationMinSize) + 2.5 * this.animationMaxSize - 2.5 * this.animationMinSize;
        double d3 = -(d1 + Math.abs(d1)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        double d4 = -(d2 + Math.abs(d2)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        this.animationScale = -(d3 + Math.abs(d3) + d4 + Math.abs(d4)) / 4.0 + this.animationMaxSize;
    }

    public void animateFade(float partialTicks) {
        if (!this.animationFade.booleanValue()) {
            return;
        }
        double d1 = (double)((float)this.lifetime - ((float)(this.age - 1) + partialTicks)) + (double)this.lifetime / 6.0;
        double d2 = (double)((float)this.lifetime - ((float)(this.age - 1) + partialTicks)) - (double)this.lifetime / 6.0;
        this.alpha = (float)((d1 - Math.abs(d2)) / ((double)this.lifetime / 3.0));
    }

    public static class DamageParticle
    extends ParticleRenderer {
        public DamageParticle(ClientLevel clientLevel, double x, double y, double z) {
            super(clientLevel, x, y, z);
            this.tick();
        }

        public void tick() {
            if (this.age++ >= this.lifetime) {
                this.remove();
                return;
            }
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.yd = 0.12 * (2.0 * (double)(this.age - 1) - (double)this.lifetime) * (2.0 * (double)(this.age - 1) - (double)this.lifetime) / (double)(this.lifetime * this.lifetime);
            this.move(this.xd, this.yd, this.zd);
        }
    }
}

