/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.data.BarState;
import com.jahirtrap.healthindicator.data.BarStates;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BarRenderer {
    private static final ResourceLocation GUI_BARS_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"healthindicatortxf", (String)"textures/gui/bars.png");

    public static void render(GuiGraphics guiGraphics, LivingEntity entity, int width, int height, boolean armor, boolean bar, int wVal1, int wVal2, int oVal1) {
        CommonUtils.EntityType entityType = CommonUtils.getEntityType((Entity)entity);
        int color = 0x8000FF;
        int color2 = 0x400080;
        if (entityType == CommonUtils.EntityType.PASSIVE) {
            color = CommonUtils.getColor(65280, ModConfig.passiveColor);
            color2 = CommonUtils.getColor(32768, ModConfig.passiveColorSecondary);
        } else if (entityType == CommonUtils.EntityType.HOSTILE) {
            color = CommonUtils.getColor(0xFF0000, ModConfig.hostileColor);
            color2 = CommonUtils.getColor(0x800000, ModConfig.hostileColorSecondary);
        } else if (entityType == CommonUtils.EntityType.NEUTRAL) {
            color = CommonUtils.getColor(255, ModConfig.neutralColor);
            color2 = CommonUtils.getColor(128, ModConfig.neutralColorSecondary);
        }
        int color3 = CommonUtils.getColor(0x808080, ModConfig.backgroundBarColor);
        int color4 = CommonUtils.getColor(0, ModConfig.hudBackgroundColor);
        int alpha4 = ModConfig.hudBackgroundOpacity;
        BarState state = BarStates.getState(entity);
        float percent = Math.min(1.0f, Math.min(state.health, entity.getMaxHealth()) / entity.getMaxHealth());
        float percent2 = Math.min(state.previousHealthDisplay, entity.getMaxHealth()) / entity.getMaxHealth();
        if (!bar) {
            width = 0;
        }
        if (alpha4 > 0) {
            if (width >= wVal1 && width >= wVal2) {
                oVal1 = 0;
            }
            BarRenderer.drawBackground(guiGraphics, color4, alpha4, wVal1, Math.max(Math.max(width, wVal1), wVal2), oVal1);
        }
        if (!bar) {
            return;
        }
        if (ModConfig.showBackgroundBar) {
            BarRenderer.drawBar(guiGraphics, width, height, 1.0f, color3, true, armor);
        }
        if (ModConfig.showSecondaryBar) {
            BarRenderer.drawBar(guiGraphics, width, height, percent2, color2, false, armor);
        }
        BarRenderer.drawBar(guiGraphics, width, height, percent, color, false, armor);
    }

    private static void drawBar(GuiGraphics guiGraphics, int width, int height, float percent, int color, boolean back, boolean armor) {
        int v = 10;
        switch (ModConfig.barStyle) {
            case VANILLA: {
                v -= height;
                break;
            }
            case DEFAULT: {
                v += height;
                break;
            }
            case ROUNDED: {
                v += height * 3;
                break;
            }
            case GRADIENT: {
                v += height * 5;
                break;
            }
            case MINIMALIST: {
                v += height * 7;
                break;
            }
            case MODERN: {
                v += height * 9;
            }
        }
        if (back) {
            v -= height;
        }
        int y = !ModConfig.showName && !ModConfig.showHealth && (!armor || !ModConfig.showArmor) ? 0 : 12;
        int size = (int)(percent * (float)width);
        int argb = 0xFF000000 | color & 0xFFFFFF;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_BARS_TEXTURES, 0, y, 0.0f, (float)v, size, height, 128, 128, argb);
    }

    private static void drawBackground(GuiGraphics guiGraphics, int color, int alpha, int wVal1, int maxWidth, int minOffset) {
        int padding = 3;
        int xw = maxWidth + minOffset + padding;
        int x = minOffset - padding;
        switch (ModConfig.position) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                --x;
                break;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                ++xw;
            }
        }
        int yh = CommonUtils.getHudHeight(wVal1) + 1 + padding;
        int y = 1 - padding;
        int argb = Math.round((float)alpha / 100.0f * 255.0f) << 24 | color & 0xFFFFFF;
        guiGraphics.fill(x, y, xw, y + yh, argb);
    }
}

