/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.util.CommonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.state.ParticleGroupRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ParticleRenderer
extends Particle {
    public static final ParticleRenderType CUSTOM = new ParticleRenderType("healthindicatortxf:particle_renderer");
    private float rCol = 1.0f;
    private float gCol = 1.0f;
    private float bCol = 1.0f;
    private float alpha = 1.0f;
    private String text;
    private double scale = 1.0;
    private double animationScale;
    private Double animationMinSize;
    private Double animationMaxSize;
    private Boolean animationFade;

    public ParticleRenderer(ClientLevel clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int color) {
        this.rCol = CommonUtils.getRedFromColor(color);
        this.gCol = CommonUtils.getGreenFromColor(color);
        this.bCol = CommonUtils.getBlueFromColor(color);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setAnimationSize(double min, double max) {
        this.animationMinSize = min;
        this.animationMaxSize = max;
    }

    public void setAnimationFade(boolean animationFade) {
        this.animationFade = animationFade;
    }

    @NotNull
    public ParticleRenderType getGroup() {
        return CUSTOM;
    }

    public void animateSize(float partialTicks) {
        if (this.animationMinSize == null || this.animationMaxSize == null) {
            return;
        }
        double d1 = 6.0 * (double)((float)(this.age - 1) + partialTicks) / (double)this.lifetime * (this.animationMaxSize - this.animationMinSize) - this.animationMaxSize + this.animationMinSize;
        double d2 = -3.0 * (double)((float)(this.age - 1) + partialTicks) / (double)this.lifetime * (this.animationMaxSize - this.animationMinSize) + 2.5 * this.animationMaxSize - 2.5 * this.animationMinSize;
        double d3 = -(d1 + Math.abs(d1)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        double d4 = -(d2 + Math.abs(d2)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        this.animationScale = -(d3 + Math.abs(d3) + d4 + Math.abs(d4)) / 4.0 + this.animationMaxSize;
    }

    public void animateFade(float partialTicks) {
        if (!this.animationFade.booleanValue()) {
            return;
        }
        double d1 = (double)((float)this.lifetime - ((float)(this.age - 1) + partialTicks)) + (double)this.lifetime / 6.0;
        double d2 = (double)((float)this.lifetime - ((float)(this.age - 1) + partialTicks)) - (double)this.lifetime / 6.0;
        this.alpha = (float)((d1 - Math.abs(d2)) / ((double)this.lifetime / 3.0));
    }

    public static class ParticleRendererGroup
    extends ParticleGroup<ParticleRenderer> {
        public ParticleRendererGroup(ParticleEngine engine) {
            super(engine);
        }

        @NotNull
        public ParticleGroupRenderState extractRenderState(Frustum frustum, Camera camera, float partialTick) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.particles.size());
            Vec3 pos = camera.getPosition();
            for (ParticleRenderer p : this.particles) {
                if (p.alpha == 0.0f) continue;
                float x = (float)(p.xo + (p.x - p.xo) * (double)partialTick - pos.x());
                float y = (float)(p.yo + (p.y - p.yo) * (double)partialTick - pos.y());
                float z = (float)(p.zo + (p.z - p.zo) * (double)partialTick - pos.z());
                int color = CommonUtils.getColorFromRGBA(p.rCol, p.gCol, p.bCol, p.alpha);
                p.animateSize(partialTick);
                p.animateFade(partialTick);
                Matrix4f matrix = new Matrix4f().translate(x, y, z).rotate((Quaternionfc)camera.rotation()).rotate((float)Math.PI, 0.0f, 1.0f, 0.0f).scale(-0.024f, -0.024f, -0.024f);
                float scale = (float)((p.animationScale != 0.0 ? p.animationScale : 1.0) * p.scale);
                entries.add(new Entry(matrix, p.text, color, scale));
            }
            return new State(entries);
        }

        public static final class Entry {
            public final Matrix4f pose;
            public final String text;
            public final int color;
            public final float scale;

            Entry(Matrix4f pose, String text, int color, float scale) {
                this.pose = pose;
                this.text = text;
                this.color = color;
                this.scale = scale;
            }
        }

        public record State(List<Entry> entries) implements ParticleGroupRenderState
        {
            public void submit(SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
                Minecraft mc = Minecraft.getInstance();
                for (Entry entry : this.entries) {
                    if (entry.text == null || entry.text.isEmpty()) continue;
                    float textX = -mc.font.width(entry.text) / 2;
                    float textY = -mc.font.wordWrapHeight(entry.text, 0);
                    PoseStack poseStack = new PoseStack();
                    poseStack.last().pose().set((Matrix4fc)entry.pose);
                    poseStack.scale(entry.scale, entry.scale, 1.0f);
                    collector.submitText(poseStack, textX, textY, Component.literal((String)entry.text).getVisualOrderText(), true, Font.DisplayMode.NORMAL, 0xF000F0, entry.color, 0, 0);
                }
            }
        }
    }

    public static class DamageParticle
    extends ParticleRenderer {
        public DamageParticle(ClientLevel clientLevel, double x, double y, double z) {
            super(clientLevel, x, y, z);
            this.tick();
        }

        public void tick() {
            if (this.age++ >= this.lifetime) {
                this.remove();
                return;
            }
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.yd = 0.12 * (2.0 * (double)(this.age - 1) - (double)this.lifetime) * (2.0 * (double)(this.age - 1) - (double)this.lifetime) / (double)(this.lifetime * this.lifetime);
            this.move(this.xd, this.yd, this.zd);
        }
    }
}

