/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarRenderer;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class BarDisplay {
    private static final class_2960 ARMOR_FULL_SPRITE = class_2960.method_60656((String)"hud/armor_full");
    private static final class_2960 HEART_CONTAINER_SPRITE = class_2960.method_60656((String)"hud/heart/container");
    private static final class_2960 HEART_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/full");
    private final class_310 mc;
    private int infoWidth;

    public BarDisplay(class_310 mc) {
        this.mc = mc;
    }

    public void draw(class_332 guiGraphics, class_1309 entity) {
        int armorValue;
        int barWidth = 128;
        int barHeight = 6;
        int xOffset = 1;
        int xOffsetM = 1;
        int yOffset = 2;
        if (ModConfig.barStyle == ModConfig.BarStyle.VANILLA) {
            barHeight = 5;
        }
        boolean armor = (armorValue = entity.method_6096()) > 0;
        String name = entity.method_5476().getString();
        float health = entity.method_6032() + entity.method_6067();
        float maxHealth = entity.method_6063() + entity.method_6067();
        String healthMax = String.valueOf(class_3532.method_15386((float)maxHealth));
        String healthCur = String.valueOf(Math.min(class_3532.method_15386((float)health), Integer.parseInt(healthMax)));
        if (ModConfig.showHealthDecimals) {
            healthMax = CommonUtils.formatText(maxHealth);
            healthCur = CommonUtils.formatText(Math.min(health, maxHealth));
        }
        Object healthText = healthCur + "/" + healthMax;
        String armorText = String.valueOf(armorValue);
        String modNameText = CommonUtils.getModName(entity);
        switch (ModConfig.healthTextFormat) {
            case CURRENT_HEALTH: {
                healthText = healthCur;
                break;
            }
            case MAX_HEALTH: {
                healthText = healthMax;
            }
        }
        boolean showName = ModConfig.showName;
        boolean showHealth = ModConfig.showHealth;
        boolean showArmor = ModConfig.showArmor;
        boolean showModName = ModConfig.showModName;
        boolean showBar = ModConfig.showBar;
        this.setInfoWidth(name, armor, (String)healthText, armorText);
        int offAux = this.getInfoWidth();
        int center = barWidth / 2 - offAux / 2;
        int right = barWidth - offAux - xOffset;
        int centerM = barWidth / 2 - this.mc.field_1772.method_1727(modNameText) / 2;
        int rightM = barWidth - this.mc.field_1772.method_1727(modNameText) - xOffsetM;
        switch (ModConfig.position) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                xOffset = center;
                xOffsetM = centerM;
                break;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                xOffset = right;
                xOffsetM = rightM;
            }
        }
        BarRenderer.render(guiGraphics, entity, barWidth, barHeight, armor, showBar, offAux, this.mc.field_1772.method_1727(modNameText), Math.min(xOffset, xOffsetM));
        if (showName && !name.isBlank()) {
            guiGraphics.method_25303(this.mc.field_1772, name, xOffset, yOffset, -1);
            xOffset += this.mc.field_1772.method_1727(name) + 5;
        }
        if (showHealth) {
            this.renderHeartIcon(guiGraphics, xOffset, entity);
            guiGraphics.method_25303(this.mc.field_1772, (String)healthText, xOffset += 10, yOffset, -1);
            xOffset += this.mc.field_1772.method_1727((String)healthText) + 5;
        }
        if (armor && showArmor) {
            this.renderArmorIcon(guiGraphics, xOffset);
            guiGraphics.method_25303(this.mc.field_1772, armorText, xOffset += 10, yOffset, -1);
        }
        if (showModName && !modNameText.isBlank()) {
            yOffset = 15 + barHeight;
            if (offAux == 0) {
                yOffset -= 12;
            }
            if (!showBar) {
                yOffset -= barHeight + 2;
            }
            guiGraphics.method_25303(this.mc.field_1772, modNameText, xOffsetM, yOffset, 0xFF000000 | CommonUtils.getColor(0x5555FF, ModConfig.modNameColor) & 0xFFFFFF);
        }
    }

    private void renderArmorIcon(class_332 guiGraphics, int x) {
        guiGraphics.method_52706(class_10799.field_56883, ARMOR_FULL_SPRITE, x, 1, 9, 9);
    }

    private void renderHeartIcon(class_332 guiGraphics, int x, class_1309 entity) {
        class_2960 icon = HEART_FULL_SPRITE;
        guiGraphics.method_52706(class_10799.field_56883, HEART_CONTAINER_SPRITE, x, 1, 9, 9);
        if (ModConfig.dynamicHeartTexture) {
            icon = this.getHeartSprite(entity);
        }
        guiGraphics.method_52706(class_10799.field_56883, icon, x, 1, 9, 9);
    }

    private class_2960 getHeartSprite(class_1309 entity) {
        class_2960 HEART_FROZEN_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/frozen_full");
        class_2960 HEART_ABSORBING_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/absorbing_full");
        class_2960 HEART_X_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/hardcore_full");
        class_2960 HEART_X_FROZEN_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/frozen_hardcore_full");
        class_2960 HEART_X_ABSORBING_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/absorbing_hardcore_full");
        class_2960 icon = HEART_FULL_SPRITE;
        boolean hardcore = false;
        if (entity instanceof class_1657 && this.mc.field_1687 != null && this.mc.field_1687.method_28104().method_152()) {
            hardcore = true;
            icon = HEART_X_FULL_SPRITE;
        }
        if (entity.method_32312() >= entity.method_32315()) {
            icon = !hardcore ? HEART_FROZEN_FULL_SPRITE : HEART_X_FROZEN_FULL_SPRITE;
        } else if (entity.method_6067() > 0.0f) {
            icon = !hardcore ? HEART_ABSORBING_FULL_SPRITE : HEART_X_ABSORBING_FULL_SPRITE;
        }
        return icon;
    }

    public void setInfoWidth(String name, boolean armor, String healthText, String armorText) {
        int infoWidth = 0;
        boolean aux = true;
        if (ModConfig.showName && !name.isBlank()) {
            infoWidth += this.mc.field_1772.method_1727(name);
            if (ModConfig.showHealth) {
                infoWidth += 5;
                aux = false;
            }
            if (armor && ModConfig.showArmor) {
                infoWidth += 5;
            }
        }
        if (ModConfig.showHealth) {
            infoWidth += this.mc.field_1772.method_1727(healthText) + 10;
            if (armor && ModConfig.showArmor && aux) {
                infoWidth += 5;
            }
        }
        if (armor && ModConfig.showArmor) {
            infoWidth += this.mc.field_1772.method_1727(armorText) + 10;
        }
        this.infoWidth = infoWidth;
    }

    public int getInfoWidth() {
        return this.infoWidth;
    }
}

