/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarDisplay;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

public class Hud
extends class_437 {
    private final BarDisplay barDisplay;
    private class_1309 entity;
    private int age;

    public Hud() {
        super((class_2561)class_2561.method_43473());
        this.field_22787 = class_310.method_1551();
        this.barDisplay = new BarDisplay(this.field_22787);
    }

    public void draw(class_332 guiGraphics) {
        if (this.field_22787 != null && (this.field_22787.method_53526().method_53536() || this.field_22787.field_1690.field_1842)) {
            return;
        }
        float scale = (float)ModConfig.scale;
        float x = this.determineX();
        float y = this.determineY();
        this.draw(guiGraphics, guiGraphics.method_51448(), x, y, scale);
    }

    private float determineX() {
        float scale = (float)ModConfig.scale;
        float barWidth = (float)CommonUtils.getHudWidth() * scale;
        float x = (float)ModConfig.xValue;
        ModConfig.Position position = ModConfig.position;
        float wScreen = 0.0f;
        if (this.field_22787 != null) {
            wScreen = this.field_22787.method_22683().method_4486();
        }
        float xV = x + 3.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.TOP_CENTER -> wScreen / 2.0f + x - barWidth / 2.0f;
            case ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.TOP_RIGHT -> wScreen - xV - barWidth;
            default -> xV;
        };
    }

    private float determineY() {
        float scale = (float)ModConfig.scale;
        float barHeight = (float)CommonUtils.getHudHeight(this.barDisplay.getInfoWidth()) * scale;
        float y = (float)ModConfig.yValue;
        ModConfig.Position position = ModConfig.position;
        float hScreen = 0.0f;
        if (this.field_22787 != null) {
            hScreen = this.field_22787.method_22683().method_4502();
        }
        float yV = y + 2.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.BOTTOM_LEFT -> hScreen - yV - barHeight;
            default -> yV;
        };
    }

    public void method_25393() {
        ++this.age;
    }

    private void setEntityWork(class_1309 entity) {
        this.entity = entity;
    }

    public void setEntity(class_1309 entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > ModConfig.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && !ModConfig.showInvisibleEntities && entity.method_5767() && !entity.method_5851() && !entity.method_5809()) {
            this.setEntityWork(null);
        } else if (entity != null && !ModConfig.showBosses && entity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            this.setEntityWork(null);
        } else if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void draw(class_332 guiGraphics, Matrix3x2fStack matrix, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        if (!(ModConfig.showName || ModConfig.showHealth || ModConfig.showArmor || ModConfig.showBar || ModConfig.showModName)) {
            return;
        }
        if (CommonUtils.checkBlacklist(ModConfig.blacklist, this.entity) || CommonUtils.checkBlacklist(ModConfig.barBlacklist, this.entity)) {
            return;
        }
        matrix.pushMatrix();
        matrix.translate(x, y);
        matrix.scale(scale, scale);
        if (ModConfig.enableMod && ModConfig.showHud) {
            this.barDisplay.draw(guiGraphics, this.entity);
        }
        matrix.popMatrix();
    }
}

