/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.util.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_11938;
import net.minecraft.class_11942;
import net.minecraft.class_12075;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ParticleRenderer
extends class_703 {
    public static final class_3999 CUSTOM = new class_3999("healthindicatortxf:particle_renderer");
    private float rCol = 1.0f;
    private float gCol = 1.0f;
    private float bCol = 1.0f;
    private float alpha = 1.0f;
    private String text;
    private double scale = 1.0;
    private double animationScale;
    private Double animationMinSize;
    private Double animationMaxSize;
    private Boolean animationFade;

    public ParticleRenderer(class_638 clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z);
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int color) {
        this.rCol = CommonUtils.getRedFromColor(color);
        this.gCol = CommonUtils.getGreenFromColor(color);
        this.bCol = CommonUtils.getBlueFromColor(color);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setAnimationSize(double min, double max) {
        this.animationMinSize = min;
        this.animationMaxSize = max;
    }

    public void setAnimationFade(boolean animationFade) {
        this.animationFade = animationFade;
    }

    @NotNull
    public class_3999 method_74274() {
        return CUSTOM;
    }

    public void animateSize(float partialTicks) {
        if (this.animationMinSize == null || this.animationMaxSize == null) {
            return;
        }
        double d1 = 6.0 * (double)((float)(this.field_3866 - 1) + partialTicks) / (double)this.field_3847 * (this.animationMaxSize - this.animationMinSize) - this.animationMaxSize + this.animationMinSize;
        double d2 = -3.0 * (double)((float)(this.field_3866 - 1) + partialTicks) / (double)this.field_3847 * (this.animationMaxSize - this.animationMinSize) + 2.5 * this.animationMaxSize - 2.5 * this.animationMinSize;
        double d3 = -(d1 + Math.abs(d1)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        double d4 = -(d2 + Math.abs(d2)) + 2.0 * this.animationMaxSize - 2.0 * this.animationMinSize;
        this.animationScale = -(d3 + Math.abs(d3) + d4 + Math.abs(d4)) / 4.0 + this.animationMaxSize;
    }

    public void animateFade(float partialTicks) {
        if (!this.animationFade.booleanValue()) {
            return;
        }
        double d1 = (double)((float)this.field_3847 - ((float)(this.field_3866 - 1) + partialTicks)) + (double)this.field_3847 / 6.0;
        double d2 = (double)((float)this.field_3847 - ((float)(this.field_3866 - 1) + partialTicks)) - (double)this.field_3847 / 6.0;
        this.alpha = (float)((d1 - Math.abs(d2)) / ((double)this.field_3847 / 3.0));
    }

    public static class ParticleRendererGroup
    extends class_11938<ParticleRenderer> {
        public ParticleRendererGroup(class_702 engine) {
            super(engine);
        }

        @NotNull
        public class_11942 method_74276(class_4604 frustum, class_4184 camera, float partialTick) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.field_62620.size());
            class_243 pos = camera.method_19326();
            for (ParticleRenderer p : this.field_62620) {
                if (p.alpha == 0.0f) continue;
                float x = (float)(p.field_3858 + (p.field_3874 - p.field_3858) * (double)partialTick - pos.method_10216());
                float y = (float)(p.field_3838 + (p.field_3854 - p.field_3838) * (double)partialTick - pos.method_10214());
                float z = (float)(p.field_3856 + (p.field_3871 - p.field_3856) * (double)partialTick - pos.method_10215());
                int color = CommonUtils.getColorFromRGBA(p.rCol, p.gCol, p.bCol, p.alpha);
                p.animateSize(partialTick);
                p.animateFade(partialTick);
                Matrix4f matrix = new Matrix4f().translate(x, y, z).rotate((Quaternionfc)camera.method_23767()).rotate((float)Math.PI, 0.0f, 1.0f, 0.0f).scale(-0.024f, -0.024f, -0.024f);
                float scale = (float)((p.animationScale != 0.0 ? p.animationScale : 1.0) * p.scale);
                entries.add(new Entry(matrix, p.text, color, scale));
            }
            return new State(entries);
        }

        public static final class Entry {
            public final Matrix4f pose;
            public final String text;
            public final int color;
            public final float scale;

            Entry(Matrix4f pose, String text, int color, float scale) {
                this.pose = pose;
                this.text = text;
                this.color = color;
                this.scale = scale;
            }
        }

        public record State(List<Entry> entries) implements class_11942
        {
            public void submit(class_11659 collector, class_12075 cameraRenderState) {
                class_310 mc = class_310.method_1551();
                for (Entry entry : this.entries) {
                    if (entry.text == null || entry.text.isEmpty()) continue;
                    float textX = -mc.field_1772.method_1727(entry.text) / 2;
                    float textY = -mc.field_1772.method_1713(entry.text, 0);
                    class_4587 poseStack = new class_4587();
                    poseStack.method_23760().method_23761().set((Matrix4fc)entry.pose);
                    poseStack.method_22905(entry.scale, entry.scale, 1.0f);
                    collector.method_73478(poseStack, textX, textY, class_2561.method_43470((String)entry.text).method_30937(), true, class_327.class_6415.field_33993, 0xF000F0, entry.color, 0, 0);
                }
            }
        }
    }

    public static class DamageParticle
    extends ParticleRenderer {
        public DamageParticle(class_638 clientLevel, double x, double y, double z) {
            super(clientLevel, x, y, z);
            this.method_3070();
        }

        public void method_3070() {
            if (this.field_3866++ >= this.field_3847) {
                this.method_3085();
                return;
            }
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            this.field_3869 = 0.12 * (2.0 * (double)(this.field_3866 - 1) - (double)this.field_3847) * (2.0 * (double)(this.field_3866 - 1) - (double)this.field_3847) / (double)(this.field_3847 * this.field_3847);
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }
}

