/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.init.mixin;

import com.jahirtrap.healthindicator.data.EntityData;
import com.jahirtrap.healthindicator.display.ParticleRenderer;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Unique
    private static final WeakHashMap<class_1309, EntityData> ENTITY_TRACKER = new WeakHashMap();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    @Environment(value=EnvType.CLIENT)
    private void tick(CallbackInfo ci) {
        if (!ModConfig.showHealingParticles && !ModConfig.showDamageParticles || !ModConfig.enableMod) {
            return;
        }
        class_1297 entity = (class_1297)this;
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (CommonUtils.checkBlacklist(ModConfig.blacklist, livingEntity) || CommonUtils.checkBlacklist(ModConfig.numberParticleBlacklist, livingEntity)) {
            return;
        }
        EntityData entityData = ENTITY_TRACKER.get(livingEntity);
        if (entityData == null) {
            entityData = new EntityData(livingEntity);
            ENTITY_TRACKER.put(livingEntity, entityData);
        } else {
            entityData.update(livingEntity);
        }
        if (entityData.damage != 0.0f) {
            EntityMixin.addParticle(livingEntity, entityData);
        }
    }

    @Inject(method={"setLevel"}, at={@At(value="HEAD")})
    @Environment(value=EnvType.CLIENT)
    private void setLevel(CallbackInfo ci) {
        class_1297 entity = (class_1297)this;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (entity.equals((Object)player)) {
            ENTITY_TRACKER.clear();
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private static void addParticle(class_1309 livingEntity, EntityData entityData) {
        if (entityData.damage > 0.0f && !ModConfig.showDamageParticles) {
            return;
        }
        if (entityData.damage < 0.0f && !ModConfig.showHealingParticles) {
            return;
        }
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel == null) {
            return;
        }
        class_1297 entity = clientLevel.method_8469(livingEntity.method_5628());
        if (entity == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (livingEntity.equals((Object)player)) {
            return;
        }
        String damageString = CommonUtils.formatDamageText(entityData.damage);
        int color = CommonUtils.getColor(0xFCFCFC, ModConfig.damageParticleColor);
        if (entityData.damage < 0.0f && !ModConfig.showHealingParticles) {
            color = CommonUtils.getColor(64512, ModConfig.healingParticleColor);
        }
        double posX = livingEntity.method_23317();
        double posY = livingEntity.method_20802() > 0 ? livingEntity.method_5829().field_1325 + 1.24 : livingEntity.method_5829().field_1325 + 0.24;
        double posZ = livingEntity.method_23321();
        ParticleRenderer.DamageParticle damageParticle = new ParticleRenderer.DamageParticle(clientLevel, posX, posY, posZ);
        damageParticle.setText(damageString);
        damageParticle.setColor(color);
        damageParticle.setScale(ModConfig.particleScale);
        damageParticle.setAnimationSize(1.0, 1.5);
        damageParticle.setAnimationFade(true);
        damageParticle.method_3077(20);
        class_310.method_1551().field_1713.method_3058((class_703)damageParticle);
    }
}

