/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.util;

import com.jahirtrap.healthindicator.display.Hud;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.RayTrace;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1501;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1593;
import net.minecraft.class_1606;
import net.minecraft.class_1621;
import net.minecraft.class_4760;
import net.minecraft.class_5354;
import net.minecraft.class_7923;

public class CommonUtils {
    public static final Hud HUD = new Hud();
    public static final RayTrace RAYTRACE = new RayTrace();

    public static EntityType getEntityType(class_1297 entity) {
        if (entity instanceof class_5354 || entity instanceof class_1501) {
            return EntityType.NEUTRAL;
        }
        if (entity instanceof class_1588 || entity instanceof class_1621 || entity instanceof class_1571 || entity instanceof class_4760 || entity instanceof class_1593 || entity instanceof class_1606) {
            return EntityType.HOSTILE;
        }
        return EntityType.PASSIVE;
    }

    public static String getModName(class_1309 entity) {
        String modId = class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836();
        return FabricLoader.getInstance().getModContainer(modId).map(container -> container.getMetadata().getName()).orElse(modId);
    }

    public static String getEntityId(class_1309 entity) {
        return class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
    }

    public static boolean checkBlacklist(List<String> blacklist, class_1309 entity) {
        if (!blacklist.isEmpty()) {
            for (String entityId : blacklist) {
                if (!CommonUtils.getEntityId(entity).equals(entityId)) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getColor(int defaultValue, String hexColor) {
        int color = defaultValue;
        try {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            color = Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    public static String formatText(float amount) {
        amount = (float)((double)Math.round(amount * 10.0f) / 10.0);
        return String.format("%.1f", Float.valueOf(amount));
    }

    public static String formatDamageText(float amount) {
        if ((double)(amount = (float)((double)Math.round(amount * 10.0f) / 10.0)) % 1.0 == 0.0) {
            return String.format("%.0f", Float.valueOf(amount)).replace("-", "+");
        }
        return String.format("%.1f", Float.valueOf(amount)).replace("-", "+");
    }

    public static int getHudWidth() {
        return 128;
    }

    public static int getHudHeight(int infoWidth) {
        int value = 30;
        if (ModConfig.barStyle == ModConfig.BarStyle.VANILLA) {
            --value;
        }
        if (!ModConfig.showBar) {
            value = ModConfig.barStyle == ModConfig.BarStyle.VANILLA ? (value -= 5) : (value -= 6);
            if (ModConfig.showModName) {
                value -= 2;
            }
        }
        if (infoWidth == 0) {
            value -= 12;
        }
        if (!ModConfig.showModName) {
            value -= 12;
        }
        return value;
    }

    public static float getRedFromColor(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreenFromColor(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlueFromColor(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlphaFromColor(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static int getColorFromRGBA(float red, float green, float blue, float alpha) {
        return (int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static enum EntityType {
        PASSIVE,
        HOSTILE,
        NEUTRAL;

    }
}

