/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.display;

import com.jahirtrap.healthindicator.display.BarDisplay;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.Tags;
import org.joml.Matrix3x2fStack;

public class Hud
extends Screen {
    private final BarDisplay barDisplay;
    private LivingEntity entity;
    private int age;

    public Hud() {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        this.barDisplay = new BarDisplay(this.minecraft);
    }

    public void draw(GuiGraphics guiGraphics) {
        if (this.minecraft != null && (this.minecraft.getDebugOverlay().showDebugScreen() || this.minecraft.options.hideGui)) {
            return;
        }
        float scale = (float)ModConfig.scale;
        float x = this.determineX();
        float y = this.determineY();
        this.draw(guiGraphics, guiGraphics.pose(), x, y, scale);
    }

    private float determineX() {
        float scale = (float)ModConfig.scale;
        float barWidth = (float)CommonUtils.getHudWidth() * scale;
        float x = (float)ModConfig.xValue;
        ModConfig.Position position = ModConfig.position;
        float wScreen = 0.0f;
        if (this.minecraft != null) {
            wScreen = this.minecraft.getWindow().getGuiScaledWidth();
        }
        float xV = x + 3.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.TOP_CENTER -> wScreen / 2.0f + x - barWidth / 2.0f;
            case ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.TOP_RIGHT -> wScreen - xV - barWidth;
            default -> xV;
        };
    }

    private float determineY() {
        float scale = (float)ModConfig.scale;
        float barHeight = (float)CommonUtils.getHudHeight(this.barDisplay.getInfoWidth()) * scale;
        float y = (float)ModConfig.yValue;
        ModConfig.Position position = ModConfig.position;
        float hScreen = 0.0f;
        if (this.minecraft != null) {
            hScreen = this.minecraft.getWindow().getGuiScaledHeight();
        }
        float yV = y + 2.0f * scale;
        return switch (position) {
            case ModConfig.Position.BOTTOM_CENTER, ModConfig.Position.BOTTOM_RIGHT, ModConfig.Position.BOTTOM_LEFT -> hScreen - yV - barHeight;
            default -> yV;
        };
    }

    public void tick() {
        ++this.age;
    }

    private void setEntityWork(LivingEntity entity) {
        this.entity = entity;
    }

    public void setEntity(LivingEntity entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > ModConfig.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && !ModConfig.showInvisibleEntities && entity.isInvisible() && !entity.isCurrentlyGlowing() && !entity.isOnFire()) {
            this.setEntityWork(null);
        } else if (entity != null && !ModConfig.showBosses && entity.getType().is(Tags.EntityTypes.BOSSES)) {
            this.setEntityWork(null);
        } else if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void draw(GuiGraphics guiGraphics, Matrix3x2fStack matrix, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        if (!(ModConfig.showName || ModConfig.showHealth || ModConfig.showArmor || ModConfig.showBar || ModConfig.showModName)) {
            return;
        }
        if (CommonUtils.checkBlacklist(ModConfig.blacklist, this.entity) || CommonUtils.checkBlacklist(ModConfig.barBlacklist, this.entity)) {
            return;
        }
        matrix.pushMatrix();
        matrix.translate(x, y);
        matrix.scale(scale, scale);
        if (ModConfig.enableMod && ModConfig.showHud) {
            this.barDisplay.draw(guiGraphics, this.entity);
        }
        matrix.popMatrix();
    }
}

