/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.init.mixin;

import com.jahirtrap.healthindicator.data.EntityData;
import com.jahirtrap.healthindicator.display.ParticleRenderer;
import com.jahirtrap.healthindicator.init.ModConfig;
import com.jahirtrap.healthindicator.util.CommonUtils;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private static final WeakHashMap<LivingEntity, EntityData> ENTITY_TRACKER = new WeakHashMap();

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (!ModConfig.showHealingParticles && !ModConfig.showDamageParticles || !ModConfig.enableMod) {
            return;
        }
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (CommonUtils.checkBlacklist(ModConfig.blacklist, livingEntity) || CommonUtils.checkBlacklist(ModConfig.numberParticleBlacklist, livingEntity)) {
            return;
        }
        EntityData entityData = ENTITY_TRACKER.get(livingEntity);
        if (entityData == null) {
            entityData = new EntityData(livingEntity);
            ENTITY_TRACKER.put(livingEntity, entityData);
        } else {
            entityData.update(livingEntity);
        }
        if (entityData.damage != 0.0f) {
            EntityMixin.addParticle(livingEntity, entityData);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"setLevel"}, at={@At(value="HEAD")})
    private void setLevel(CallbackInfo ci) {
        Entity entity = (Entity)this;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (entity.equals((Object)player)) {
            ENTITY_TRACKER.clear();
        }
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private static void addParticle(LivingEntity livingEntity, EntityData entityData) {
        if (entityData.damage > 0.0f && !ModConfig.showDamageParticles) {
            return;
        }
        if (entityData.damage < 0.0f && !ModConfig.showHealingParticles) {
            return;
        }
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel == null) {
            return;
        }
        Entity entity = clientLevel.getEntity(livingEntity.getId());
        if (entity == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (livingEntity.equals((Object)player)) {
            return;
        }
        String damageString = CommonUtils.formatDamageText(entityData.damage);
        int color = CommonUtils.getColor(0xFCFCFC, ModConfig.damageParticleColor);
        if (entityData.damage < 0.0f && !ModConfig.showHealingParticles) {
            color = CommonUtils.getColor(64512, ModConfig.healingParticleColor);
        }
        double posX = livingEntity.getX();
        double posY = livingEntity.getRemainingFireTicks() > 0 ? livingEntity.getBoundingBox().maxY + 1.24 : livingEntity.getBoundingBox().maxY + 0.24;
        double posZ = livingEntity.getZ();
        ParticleRenderer.DamageParticle damageParticle = new ParticleRenderer.DamageParticle(clientLevel, posX, posY, posZ);
        damageParticle.setText(damageString);
        damageParticle.setColor(color);
        damageParticle.setScale(ModConfig.particleScale);
        damageParticle.setAnimationSize(1.0, 1.5);
        damageParticle.setAnimationFade(true);
        damageParticle.setLifetime(20);
        Minecraft.getInstance().particleEngine.add((Particle)damageParticle);
    }
}

