/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import playerquests.Core;
import playerquests.builder.Builder;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.client.ClientDirector;
import playerquests.client.gui.listener.GUIListener;
import playerquests.product.GUI;

public class GUIBuilder
implements Builder {
    private ClientDirector director;
    private GUI gui;
    private Map<Integer, GUISlot> guiSlots = new HashMap<Integer, GUISlot>();
    private GUIFrame guiFrame;
    private GUIListener guiListener;
    private String screenName;
    private List<String> previousScreens = new ArrayList<String>();

    public GUIBuilder(ClientDirector director) {
        new GUIBuilder(director, true);
    }

    public GUIBuilder(ClientDirector director, boolean current) {
        this.director = director;
        this.guiFrame = new GUIFrame(director);
        this.gui = new GUI(this);
        this.guiListener = new GUIListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.guiListener, Core.getPlugin());
        if (current) {
            GUIBuilder oldGUI = (GUIBuilder)this.director.getCurrentInstance(GUIBuilder.class);
            if (oldGUI != null) {
                oldGUI.getResult().minimise();
            }
            director.setCurrentInstance(this);
        }
    }

    @Override
    public void reset() {
        this.guiSlots = new HashMap<Integer, GUISlot>();
        this.guiFrame = new GUIFrame(this.director);
        this.gui = new GUI(this);
    }

    public void dispose() {
        HandlerList.unregisterAll((Listener)this.guiListener);
    }

    public void setSlot(Integer position, GUISlot slot) {
        if (this.getSlot(position) != null) {
            this.removeSlot(position);
        }
        this.guiSlots.put(position, slot);
    }

    public GUISlot getSlot(Integer position) {
        return this.guiSlots.get(position);
    }

    public Integer getEmptySlot() {
        Set<Integer> filledSlots = this.guiSlots.keySet();
        return IntStream.iterate(1, i -> i + 1).filter(slot -> !filledSlots.contains(slot)).findFirst().orElse(1);
    }

    public void removeSlot(Integer position) {
        this.guiSlots.remove(position);
    }

    public void clearSlots() {
        this.guiSlots.clear();
        this.getResult().clearSlots();
    }

    @Override
    public GUI getResult() {
        return this.gui;
    }

    public ClientDirector getDirector() {
        return this.director;
    }

    public Map<Integer, GUISlot> getSlots() {
        return this.guiSlots;
    }

    public GUIFrame getFrame() {
        return this.guiFrame;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String name) {
        this.screenName = name;
    }

    public List<String> getPreviousScreens() {
        return this.previousScreens;
    }

    public void setPreviousScreens(List<String> previousScreens) {
        this.previousScreens = previousScreens;
    }
}

