/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.data.ActionData;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class Dynamicactionconditioneditor
extends GUIDynamic {
    private ActionData actionData;
    private ActionCondition condition;

    public Dynamicactionconditioneditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.actionData = (ActionData)this.director.getCurrentInstance(ActionData.class);
        this.condition = (ActionCondition)this.director.getCurrentInstance(ActionCondition.class);
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setTitle(String.format("%s Condition Editor", this.condition.getName())).setSize(9);
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).onClick(() -> new UpdateScreen(List.of(this.previousScreen), this.director).execute());
        new GUISlot(this.gui, 2).setItem(Material.GRAY_STAINED_GLASS_PANE);
        this.condition.createEditorGUI(this, this.gui, this.director);
        new GUISlot(this.gui, this.gui.getFrame().getSize()).setItem(Material.RED_DYE).setLabel("Delete Condition").onClick(() -> {
            Optional<String> removalErr = this.actionData.removeCondition(this.condition);
            if (removalErr.isEmpty()) {
                new UpdateScreen(List.of(this.previousScreen), this.director).execute();
                return;
            }
            ChatUtils.message(removalErr.get()).player(this.director.getPlayer()).type(ChatUtils.MessageType.WARN).style(ChatUtils.MessageStyle.PRETTY).send();
        });
    }
}

