/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicmyquest
extends GUIDynamic {
    Quest quest;
    Boolean confirmDeletion = false;

    public Dynamicmyquest(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.quest = (Quest)this.director.getCurrentInstance(Quest.class);
    }

    @Override
    protected void executeCustom() {
        GUIFrame guiFrame = this.gui.getFrame();
        String questTitle = this.quest.getTitle();
        guiFrame.setTitle(String.format("Quest: %s", ChatUtils.shortenString(questTitle, 20)));
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        new GUISlot(this.gui, 3).setItem(Material.WRITABLE_BOOK).setLabel("Edit").onClick(() -> {
            this.director.setCurrentInstance(new QuestBuilder(this.director, this.quest));
            new UpdateScreen(Arrays.asList("questeditor"), this.director).execute();
        });
        new GUISlot(this.gui, 4).setItem(Material.ITEM_FRAME).setLabel("Quest Inventory").onClick(() -> new UpdateScreen(Arrays.asList("questinventory"), this.director).execute());
        if (this.confirmDeletion.equals(false)) {
            new GUISlot(this.gui, 8).setItem(Material.RED_DYE).setLabel("Delete").onClick(() -> {
                this.confirmDeletion = true;
                this.execute();
            });
        } else {
            new GUISlot(this.gui, 8).setItem(Material.RED_WOOL).setLabel("Delete (Confirm)").onClick(() -> {
                Boolean deleted = QuestRegistry.getInstance().delete(this.quest, true, true, true);
                if (!deleted.booleanValue()) {
                    return;
                }
                new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
            });
        }
        boolean isToggled = this.quest.isToggled();
        new GUISlot(this.gui, 9).setItem(isToggled ? Material.GREEN_STAINED_GLASS_PANE : Material.GRAY_STAINED_GLASS_PANE).setLabel(isToggled ? "Toggle Off" : "Toggle On").onClick(() -> {
            this.quest.toggle();
            this.execute();
        });
    }
}

