/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import playerquests.Core;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class Dynamicnextactioneditor
extends GUIDynamic {
    QuestAction<?, ?> currentAction;
    ActionData actionData;
    QuestStage selectedStage;
    List<StagePath> nextActions;

    public Dynamicnextactioneditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.currentAction = (QuestAction)this.director.getCurrentInstance(QuestAction.class);
        this.selectedStage = (QuestStage)this.director.getCurrentInstance(QuestStage.class);
        this.actionData = this.currentAction.getData();
        this.nextActions = new ArrayList<StagePath>(this.actionData.getNextActions());
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setTitle("Select Next Actions").setSize(27);
        this.createBackButton();
        if (this.selectedStage == null) {
            this.createBackButton();
            this.currentAction.getStage().getQuest().getStages().entrySet().stream().sorted((entry1, entry2) -> {
                int intValue1 = Integer.parseInt(((String)entry1.getKey()).split("_")[1]);
                int intValue2 = Integer.parseInt(((String)entry2.getKey()).split("_")[1]);
                return Integer.compare(intValue1, intValue2);
            }).forEach(entry -> this.createStageButton((QuestStage)entry.getValue()));
        } else {
            this.createBackButton();
            new GUISlot(this.gui, 2).setLabel(this.stageIsSelected() ? "Unselect this stage" : "Select this stage").setItem(this.stageIsSelected() ? Material.ORANGE_DYE : Material.YELLOW_DYE).onClick(() -> Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                StagePath stagePath = new StagePath(this.selectedStage, null);
                if (this.stageIsSelected()) {
                    this.nextActions.removeIf(path -> !path.hasActions() && path.getStage().equals(this.selectedStage.getID()));
                } else {
                    this.nextActions.add(stagePath);
                }
                this.actionData.setNextActions(this.nextActions);
                this.refresh();
            }));
            List<QuestAction<?, ?>> actions = this.selectedStage.getOrderedActions();
            actions.forEach(this::createActionButton);
        }
    }

    private GUISlot createStageButton(QuestStage stage) {
        return new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel(stage.getLabel()).setItem(Material.CHEST).onClick(() -> {
            this.director.setCurrentInstance(stage, QuestStage.class);
            this.refresh();
        });
    }

    private GUISlot createActionButton(QuestAction<?, ?> action) {
        String actionID = action.getID();
        boolean isStartPoint = this.stageIsSelected() && this.currentAction.getStage().getStartPoints().stream().anyMatch(path -> path.hasActions() && path.getActions().contains(actionID));
        boolean isSelected = this.nextActions.stream().anyMatch(path -> path.hasActions() && path.getStage().contains(action.getStage().getID()) && path.getActions().contains(actionID));
        return new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel(String.format("%s (%s)", action.getLabel(), action.getActionStateText(isSelected, isStartPoint))).setDescription(List.of(String.format("Type: %s", action.getName()))).setItem(action.getActionStateItem(isSelected, isStartPoint)).onClick(() -> this.handleActionButtonClick(isSelected, action, isStartPoint));
    }

    private void handleActionButtonClick(boolean isSelected, QuestAction<?, ?> clickedAction, boolean isStartPoint) {
        StagePath stagePath = new StagePath(clickedAction.getStage(), List.of(clickedAction));
        if (isSelected) {
            this.nextActions.removeIf(path -> {
                if (!path.hasActions()) {
                    return false;
                }
                return path.getActions().contains(clickedAction.getID());
            });
        } else if (!isStartPoint) {
            this.nextActions.add(stagePath);
        } else {
            ChatUtils.message("Cannot unset start point action.").player(this.director.getPlayer()).style(ChatUtils.MessageStyle.PRETTY).send();
        }
        this.actionData.setNextActions(this.nextActions);
        this.refresh();
    }

    private GUISlot createBackButton() {
        return new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).onClick(() -> {
            this.actionData.setNextActions(this.nextActions);
            if (this.selectedStage == null) {
                new UpdateScreen(List.of(this.previousScreen), this.director).execute();
            } else {
                this.director.removeCurrentInstance(QuestStage.class);
                this.refresh();
            }
        });
    }

    private boolean stageIsSelected() {
        String stageID = this.selectedStage.getID();
        return this.nextActions.stream().filter(path -> path.getStage().equals(stageID)).anyMatch(stage -> !stage.hasActions());
    }
}

