/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicnpceditor
extends GUIDynamic {
    private QuestNPC npc;
    private QuestBuilder quest;

    public Dynamicnpceditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.npc = (QuestNPC)this.director.getCurrentInstance(QuestNPC.class);
        this.quest = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
    }

    @Override
    protected void executeCustom() {
        this.generatePage();
    }

    private void generatePage() {
        GUIFrame guiFrame = this.gui.getFrame();
        Optional.ofNullable(this.npc.getName()).ifPresentOrElse(npcName -> guiFrame.setTitle("NPC Editor (" + npcName + ")"), () -> guiFrame.setTitle("NPC Editor"));
        GUISlot backButton = new GUISlot(this.gui, 1);
        backButton.setItem(Material.OAK_DOOR);
        backButton.setLabel("Back");
        backButton.addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        GUISlot nameButton = new GUISlot(this.gui, 3);
        String label = this.npc.getName() == null ? "Set NPC Name" : "Change NPC Name (" + this.npc.getName() + ")";
        nameButton.setItem(Material.NAME_TAG);
        nameButton.setLabel(label);
        nameButton.onClick(() -> new ChatPrompt(Arrays.asList("Set the name for this NPC", "none"), this.director).onFinish((GUIFunction func) -> {
            ChatPrompt function = (ChatPrompt)func;
            String response = function.getResponse();
            this.npc.setName(response);
            this.refresh();
        }).execute());
        GUISlot assignButton = new GUISlot(this.gui, 4);
        assignButton.setLabel(String.format("Assign %s to...", this.npc.getName() != null ? this.npc.getName() : "NPC"));
        assignButton.setItem(this.npc.getBlock());
        assignButton.addFunction(new UpdateScreen(Arrays.asList("npctypes"), this.director));
        GUISlot deleteButton = new GUISlot(this.gui, 8);
        deleteButton.setItem(Material.RED_DYE);
        deleteButton.setLabel("Delete NPC");
        deleteButton.onClick(() -> {
            this.quest.removeNPC(this.npc);
            this.quest.build().save();
            new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
        });
        GUISlot saveButton = new GUISlot(this.gui, 9);
        saveButton.setItem(Material.GREEN_DYE);
        saveButton.setLabel("Save NPC");
        saveButton.onClick(() -> {
            boolean success;
            if (this.npc.getQuest() == null) {
                this.quest.addNPC(this.npc);
            }
            if (success = this.npc.save(this.quest, this.npc).booleanValue()) {
                QuestRegistry.getInstance().submit(this.npc.getQuest());
                new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
            }
        });
        GUISlot backDivider = new GUISlot(this.gui, 2);
        GUISlot saveDivider = new GUISlot(this.gui, 7);
        backDivider.setItem(Material.BLACK_STAINED_GLASS_PANE);
        saveDivider.setItem(Material.BLACK_STAINED_GLASS_PANE);
    }
}

