/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import playerquests.Core;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;

public class Dynamicquestdiary
extends GUIDynamic {
    Player player;
    QuestClient quester;
    Map<QuestAction<?, ?>, Boolean> actionState = new HashMap();

    public Dynamicquestdiary(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.player = this.director.getPlayer();
        this.quester = Core.getQuestRegistry().getQuester(this.player);
        this.actionState.putAll(this.quester.getTrackedActions().stream().collect(Collectors.toMap(action -> action, action -> true, (prev, curr) -> curr)));
        this.actionState.putAll(this.quester.getDiary().getQuestProgress().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().flatMap(path -> path.getActions((Quest)entry.getKey()).stream())).filter(action -> !this.actionState.containsKey(action)).collect(Collectors.toMap(action -> action, action -> false, (prev, curr) -> curr)));
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setTitle("Quest Diary").setSize(54);
        IntStream.of(8, 17, 26, 35, 44, 53).forEach(position -> this.createDivider(position));
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").addFunction(new UpdateScreen(List.of(this.previousScreen), this.director));
        this.generateActionButtons();
        new GUISlot(this.gui, 9).setItem(Material.WRITTEN_BOOK).setLabel("View Diary Entries").onClick(() -> {
            this.gui.getResult().minimise();
            ItemStack book = this.createBook(this.player);
            this.player.openBook(book);
        });
    }

    private void generateActionButtons() {
        this.actionState.forEach((action, state) -> new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel(action.getStage().getQuest().getTitle()).setDescription(List.of(String.format("%s (%s)", action.getID(), Boolean.TRUE.equals(state) ? "Tracking" : "Untracked"))).setItem(Boolean.TRUE.equals(state) ? Material.GREEN_WOOL : Material.RED_WOOL));
    }

    private GUISlot createDivider(int position) {
        return new GUISlot(this.gui, position).setItem(Material.GRAY_STAINED_GLASS_PANE);
    }

    private ItemStack createBook(Player player) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        bookMeta.setAuthor(player.getName());
        bookMeta.setTitle("Quest Diary");
        bookMeta.pages(this.generateBookPages(player));
        book.setItemMeta((ItemMeta)bookMeta);
        return book;
    }

    private List<Component> generateBookPages(Player player) {
        List<Component> bookEntries = this.quester.getTrackedActions().stream().map(action -> this.formatBookEntry((QuestAction<?, ?>)action)).toList();
        bookEntries.subList(0, Math.clamp((long)bookEntries.size(), 0, 99));
        return bookEntries;
    }

    private Component formatBookEntry(QuestAction<?, ?> action) {
        Quest quest = action.getStage().getQuest();
        LocationData location = action.getLocation();
        return Component.text((String)String.format("Quest: %s%n%nAction: %s (%s)%n%n%s", quest.getTitle(), action.getLabel(), action.getName(), location != null ? location.toString() : "Unknown location"));
    }
}

