/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicactionselector;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicquesteditor
extends GUIDynamic {
    private QuestBuilder questBuilder;

    public Dynamicquesteditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.questBuilder = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
    }

    @Override
    protected void executeCustom() {
        GUIFrame guiFrame = this.gui.getFrame();
        String questTitle = this.questBuilder.getTitle();
        guiFrame.setSize(9);
        guiFrame.setTitle(String.format("Edit Quest %s", questTitle != null ? "(" + ChatUtils.shortenString(questTitle, 18) + ")" : null));
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        new GUISlot(this.gui, 3).setItem(Material.ACACIA_HANGING_SIGN).setLabel("Set Title").onClick(() -> new ChatPrompt(Arrays.asList("Enter quest title", "none"), this.director).onFinish((GUIFunction guiFunction) -> {
            ChatPrompt function = (ChatPrompt)guiFunction;
            Quest quest = this.questBuilder.build();
            Map<ItemSerialisable, Integer> questInventory = QuestRegistry.getInstance().getInventory(quest);
            QuestRegistry.getInstance().delete(quest, true, false, true);
            this.questBuilder.setTitle(function.getResponse());
            Quest newQuest = this.questBuilder.build();
            String saveMessage = newQuest.save();
            ChatUtils.message((Component)Component.text((String)saveMessage)).player(this.director.getPlayer()).send();
            QuestRegistry.getInstance().setInventory(newQuest, questInventory);
            this.director.setCurrentInstance(newQuest, Quest.class);
            new UpdateScreen(List.of(this.gui.getScreenName()), this.director).execute();
        }).execute());
        GUISlot stagesSlot = new GUISlot(this.gui, 4).setItem(Material.GRAY_STAINED_GLASS_PANE).setLabel("Quest Stages").setDescription(List.of("Add an NPC to add Stages"));
        if (!this.questBuilder.getQuestNPCs().isEmpty()) {
            stagesSlot.setItem(Material.CHEST).setLabel("Quest Stages").setDescription(List.of()).addFunction(new UpdateScreen(Arrays.asList("queststages"), this.director));
        }
        new GUISlot(this.gui, 5).setItem(Material.ENDER_CHEST).setLabel("Quest NPCs").addFunction(new UpdateScreen(Arrays.asList("questnpcs"), this.director));
        new GUISlot(this.gui, 6).setItem(Material.PISTON).setLabel(this.questBuilder.build().getStartPoints().isEmpty() ? "Set start points" : "Edit start points").onClick(() -> {
            this.director.removeCurrentInstance(QuestStage.class);
            this.director.setCurrentInstance(this.questBuilder.build().getStartPoints(), List.class);
            new UpdateScreen(List.of("actionselector"), this.director).onFinish((GUIFunction f) -> {
                UpdateScreen updateScreen = (UpdateScreen)f;
                updateScreen.getDynamicGUI().onFinish(g -> {
                    Dynamicactionselector actionSelector = (Dynamicactionselector)g;
                    this.questBuilder.setStartPoints(actionSelector.getSelectedActions());
                });
            }).execute();
        });
        new GUISlot(this.gui, 9).setItem(Material.GREEN_DYE).setLabel("Save").onClick(() -> {
            this.questBuilder.build().save();
            this.gui.getResult().close();
        });
    }
}

