/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class Dynamicquestnpcs
extends GUIDynamic {
    private QuestBuilder questBuilder;
    private Map<String, QuestNPC> questNPCs;

    public Dynamicquestnpcs(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.questBuilder = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
        this.questNPCs = this.questBuilder.getQuestNPCs(true);
    }

    @Override
    protected void executeCustom() {
        this.generatePages();
    }

    private void generatePages() {
        GUIFrame guiFrame = this.gui.getFrame();
        List keys = this.questNPCs.keySet().stream().sorted((key1, key2) -> {
            int intValue1 = Integer.parseInt(key1.split("_")[1]);
            int intValue2 = Integer.parseInt(key2.split("_")[1]);
            return Integer.compare(intValue2, intValue1);
        }).toList();
        guiFrame.setTitle("Quest NPCs (" + ChatUtils.shortenString(this.questBuilder.getTitle(), 18) + ")");
        guiFrame.setSize(54);
        keys.subList(0, Math.min(keys.size(), 36)).forEach(key -> {
            QuestNPC npc = this.questNPCs.get(key);
            Integer nextEmptySlot = this.gui.getEmptySlot();
            GUISlot npcSlot = new GUISlot(this.gui, nextEmptySlot);
            if (key.equals("npc_-1")) {
                npcSlot.setItem(Material.SPAWNER);
                npcSlot.setLabel("<Unsaved NPC>");
            } else {
                npcSlot.setItem(Material.VILLAGER_SPAWN_EGG);
                npcSlot.setLabel(npc.getTitle());
            }
            npcSlot.onClick(() -> {
                this.director.setCurrentInstance(npc);
                new UpdateScreen(Arrays.asList("npceditor"), this.director).execute();
            });
        });
        Integer nextEmptySlot = this.gui.getEmptySlot();
        GUISlot addButton = new GUISlot(this.gui, nextEmptySlot);
        addButton.setItem(Material.LIME_DYE);
        addButton.setLabel("Add NPC");
        addButton.onClick(() -> {
            QuestNPC npc = new QuestNPC();
            npc.setQuest(this.questBuilder.build());
            this.director.setCurrentInstance(npc);
            new UpdateScreen(Arrays.asList("npceditor"), this.director).execute();
        });
        GUISlot backButton = new GUISlot(this.gui, 46);
        backButton.setLabel("Back");
        backButton.setItem(Material.OAK_DOOR);
        backButton.addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
    }
}

