/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;

public class Dynamicselectnpc
extends GUIDynamic {
    private QuestBuilder quest;
    private List<QuestNPC> npcList;
    private QuestNPC selectedNPC;
    private Consumer<QuestNPC> onSelect;

    public Dynamicselectnpc(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.quest = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
        this.npcList = new ArrayList<QuestNPC>(this.quest.getQuestNPCs().values());
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setSize(Math.clamp((long)((this.npcList.size() + 8) / 9 * 9), 9, 54));
        this.gui.getFrame().setTitle("NPC Selector");
        IntStream.range(1, this.npcList.size() + 1).forEach(index -> {
            QuestNPC npc = this.npcList.get(index - 1);
            Integer slot = index + 1;
            new GUISlot(this.gui, slot).setLabel(npc.getName()).setItem(Material.VILLAGER_SPAWN_EGG).onClick(() -> this.select(npc));
        });
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
    }

    public QuestNPC onSelect(Consumer<QuestNPC> onSelect) {
        this.onSelect = onSelect;
        return this.selectedNPC;
    }

    private void select(QuestNPC npc) {
        this.selectedNPC = npc;
        if (this.onSelect != null) {
            this.onSelect.accept(npc);
        }
        new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
    }
}

