/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import java.util.List;
import java.util.function.Consumer;
import playerquests.client.ClientDirector;

public abstract class GUIFunction {
    protected List<Object> params;
    protected ClientDirector director;
    protected Boolean errored = false;
    private Consumer<GUIFunction> onFinish;

    protected GUIFunction(List<Object> params, ClientDirector director) {
        this.params = params;
        this.director = director;
    }

    public abstract void execute();

    public GUIFunction onFinish(Consumer<GUIFunction> onFinish) {
        this.onFinish = onFinish;
        return this;
    }

    public void finished() {
        if (this.onFinish != null) {
            this.onFinish.accept(this);
        }
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public void setDirector(ClientDirector director) {
        this.director = director;
    }
}

