/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import playerquests.Core;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.data.SelectMethod;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;

public class SelectBlock
extends GUIFunction {
    private Listener blockListener;
    private BlockState result;
    private Player player;
    private String prompt;
    private boolean wasSetup;
    private List<Material> deniedMaterials = List.of(Material.AIR);
    private List<SelectMethod> deniedMethods;
    private boolean cancelled;

    public SelectBlock(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    private void setup() {
        try {
            PluginUtils.validateParams(this.params, String.class, List.class, List.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.director.getPlayer()).type(ChatUtils.MessageType.ERROR).send();
        }
        this.prompt = (String)this.params.get(0);
        this.deniedMaterials = this.castDeniedMaterials(this.params.get(1));
        this.deniedMethods = this.castDeniedMethods(this.params.get(2));
        this.player = this.director.getPlayer();
        this.director.getGUI().getResult().minimise();
        this.blockListener = new SelectBlockListener(this, this, Bukkit.getPlayer((UUID)this.player.getUniqueId()));
        Bukkit.getPluginManager().registerEvents(this.blockListener, Core.getPlugin());
        this.wasSetup = true;
        this.execute();
    }

    private List<Material> castDeniedMaterials(Object object) {
        List castedDenyList = (List)object;
        return Stream.concat(this.deniedMaterials.stream(), castedDenyList.stream().filter(String.class::isInstance).map(itemString -> {
            Material material = Material.matchMaterial((String)((String)itemString));
            if (material == null) {
                ChatUtils.message(String.format("Invalid item in deniedMaterials: %s", itemString)).player(this.player).type(ChatUtils.MessageType.ERROR).send();
            }
            return material;
        })).toList();
    }

    public List<Material> getdeniedMaterials() {
        return this.deniedMaterials;
    }

    private List<SelectMethod> castDeniedMethods(Object object) {
        List castedDenyList = (List)object;
        return castedDenyList.stream().filter(SelectMethod.class::isInstance).map(SelectMethod.class::cast).toList();
    }

    public List<SelectMethod> getDeniedMethods() {
        return this.deniedMethods;
    }

    @Override
    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        ChatUtils.clearChat((HumanEntity)this.player);
        if (this.cancelled) {
            ChatUtils.message(((TextComponent)Component.text((String)"exited").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)).player(this.player).send();
            this.exit();
            return;
        }
        if (this.result == null) {
            ChatUtils.message(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)this.prompt).decorate(TextDecoration.UNDERLINED))).appendNewline()).appendNewline()).append(Component.text((String)"or type ").color((TextColor)NamedTextColor.RED))).append(Component.text((String)"exit").color((TextColor)NamedTextColor.GRAY))).player(this.player).send();
            return;
        }
        ChatUtils.message(Component.empty().append(((TextComponent)Component.text((String)("Selected: " + this.result.toString())).decorate(TextDecoration.ITALIC)).color((TextColor)NamedTextColor.GRAY))).player(this.player).send();
        this.exit();
    }

    public void setResponse(BlockState blockState) {
        BlockData blockData = (blockState = blockState.copy()).getBlockData().clone();
        if (this.deniedMaterials.contains(blockData.getMaterial())) {
            ChatUtils.message("This item is denied from being set as an NPC block.").player(this.player).type(ChatUtils.MessageType.WARN).send();
            this.result = null;
            return;
        }
        this.result = blockState;
        this.execute();
    }

    public BlockState getResult() {
        return this.result;
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this.blockListener);
        this.finished();
    }

    private void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    private class SelectBlockListener
    implements Listener {
        private SelectBlock parentClass;
        private Player player;
        private List<SelectMethod> deniedMethods;

        public SelectBlockListener(SelectBlock selectBlock, SelectBlock parent, Player player) {
            this.parentClass = parent;
            this.player = player;
            this.deniedMethods = parent.getDeniedMethods();
        }

        @EventHandler
        private void onHit(PlayerInteractEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            if (this.deniedMethods.contains((Object)SelectMethod.HIT) && this.deniedMethods.contains((Object)SelectMethod.PAT)) {
                return;
            }
            event.setCancelled(true);
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null) {
                this.parentClass.setResponse(clickedBlock.getState());
            }
        }

        @EventHandler
        private void onCommand(PlayerCommandPreprocessEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                this.parentClass.setCancelled(true);
                this.parentClass.execute();
            });
        }

        @EventHandler
        private void onChat(AsyncChatEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                String message = PlainTextComponentSerializer.plainText().serialize(event.message());
                if (ChatUtils.isExitKeyword(message)) {
                    this.parentClass.setCancelled(true);
                    this.parentClass.execute();
                }
            });
        }
    }
}

