/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import playerquests.Core;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.quest.data.LocationData;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;

public class SelectLocation
extends GUIFunction {
    private String prompt;
    private Player player;
    private boolean wasSetup;
    private LocationData location;
    private Listener locationListener;
    private BlockState blockState;

    public SelectLocation(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    private void setup() {
        try {
            PluginUtils.validateParams(this.params, String.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.player).type(ChatUtils.MessageType.ERROR).send();
        }
        this.prompt = (String)this.params.get(0);
        this.player = this.director.getPlayer();
        this.director.getGUI().getResult().minimise();
        this.locationListener = new SelectLocationListener(this, this, Bukkit.getPlayer((UUID)this.player.getUniqueId()));
        Bukkit.getPluginManager().registerEvents(this.locationListener, Core.getPlugin());
        this.wasSetup = true;
        this.execute();
    }

    @Override
    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        ChatUtils.clearChat((HumanEntity)this.player);
        if (this.location == null) {
            ChatUtils.message(Component.empty().append(Component.text((String)this.prompt).decorate(TextDecoration.UNDERLINED))).player(this.player).send();
            return;
        }
        this.exit();
    }

    public void setResponse(Location location, BlockState blockState) {
        this.location = new LocationData(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
        this.blockState = blockState;
        this.execute();
    }

    public LocationData getResult() {
        return this.location;
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            ChatUtils.message("The block was requested from LocationData, without a block having been set.").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        return this.blockState;
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this.locationListener);
        this.director.getGUI().getResult().open();
        this.finished();
    }

    private class SelectLocationListener
    implements Listener {
        private SelectLocation parentClass;
        private Player player;

        public SelectLocationListener(SelectLocation selectLocation, SelectLocation parent, Player player) {
            this.parentClass = parent;
            this.player = player;
        }

        @EventHandler
        private void onCommand(PlayerCommandPreprocessEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> this.parentClass.exit());
        }

        @EventHandler
        private void onBlockPlace(BlockPlaceEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            event.setCancelled(true);
            Block blockPlaced = event.getBlockPlaced();
            this.parentClass.setResponse(blockPlaced.getLocation(), blockPlaced.getState());
        }
    }
}

