/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import playerquests.Core;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.data.SelectMethod;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;

public class SelectMaterial
extends GUIFunction {
    private Listener blockListener;
    private ItemStack result;
    private Player player;
    private String prompt;
    private boolean wasSetup;
    private List<Material> deniedBlocks = List.of(Material.AIR);
    private List<SelectMethod> deniedMethods;
    private boolean cancelled;
    private Boolean blocksOnly;

    public SelectMaterial(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    private void setup() {
        try {
            PluginUtils.validateParams(this.params, String.class, List.class, List.class, Boolean.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.player).type(ChatUtils.MessageType.ERROR).send();
        }
        this.prompt = (String)this.params.get(0);
        this.deniedBlocks = this.castDeniedBlocks(this.params.get(1));
        this.deniedMethods = this.castDeniedMethods(this.params.get(2));
        this.blocksOnly = (Boolean)this.params.get(3);
        this.player = this.director.getPlayer();
        this.director.getGUI().getResult().minimise();
        this.blockListener = new SelectMaterialListener(this, this, Bukkit.getPlayer((UUID)this.player.getUniqueId()));
        Bukkit.getPluginManager().registerEvents(this.blockListener, Core.getPlugin());
        this.wasSetup = true;
        this.execute();
    }

    private List<Material> castDeniedBlocks(Object object) {
        List castedDenyList = (List)object;
        return Stream.concat(this.deniedBlocks.stream(), castedDenyList.stream().filter(item -> item instanceof String).map(itemString -> {
            Material material = Material.matchMaterial((String)((String)itemString));
            if (material == null) {
                ChatUtils.message(String.format("Invalid item in deniedBlocks: %s", itemString)).player(this.player).type(ChatUtils.MessageType.ERROR).send();
            }
            return material;
        })).toList();
    }

    public List<Material> getDeniedBlocks() {
        return this.deniedBlocks;
    }

    private List<SelectMethod> castDeniedMethods(Object object) {
        List castedDenyList = (List)object;
        return castedDenyList.stream().filter(method -> method instanceof SelectMethod).map(method -> (SelectMethod)((Object)((Object)method))).toList();
    }

    public List<SelectMethod> getDeniedMethods() {
        return this.deniedMethods;
    }

    @Override
    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        ChatUtils.clearChat((HumanEntity)this.player);
        if (this.cancelled) {
            ChatUtils.message(((TextComponent)Component.text((String)"exited").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)).player(this.player).send();
            this.exit();
            return;
        }
        if (this.result == null) {
            ChatUtils.message(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)this.prompt).decorate(TextDecoration.UNDERLINED))).appendNewline()).appendNewline()).append(Component.text((String)"or type ").color((TextColor)NamedTextColor.RED))).append(Component.text((String)"exit").color((TextColor)NamedTextColor.GRAY))).player(this.player).send();
            return;
        }
        ChatUtils.message(Component.empty().append(((TextComponent)Component.text((String)("Selected: " + this.result.toString())).decorate(TextDecoration.ITALIC)).color((TextColor)NamedTextColor.GRAY))).player(this.player).send();
        this.exit();
    }

    public void setResponse(ItemStack itemStack) {
        if (this.deniedBlocks.contains(itemStack.getType())) {
            ChatUtils.message("This item is denied from being set as an NPC block.").player(this.player).type(ChatUtils.MessageType.WARN).send();
            this.result = null;
            return;
        }
        if (this.blocksOnly.booleanValue() && !itemStack.getType().isBlock()) {
            ChatUtils.message("Could not set this item as an NPC block.").player(this.player).type(ChatUtils.MessageType.WARN).send();
            this.result = null;
            return;
        }
        this.result = itemStack;
        this.execute();
    }

    public void setResponse(String materialString) {
        Material material = Material.matchMaterial((String)materialString);
        if (material == null) {
            ChatUtils.message(String.format("Could not find %s block to set, needs to be the exact name.", material)).player(this.player).type(ChatUtils.MessageType.WARN).send();
        } else {
            this.setResponse(new ItemStack(material));
        }
    }

    public ItemStack getResult() {
        return this.result;
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this.blockListener);
        this.finished();
    }

    private void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    private class SelectMaterialListener
    implements Listener {
        private SelectMaterial parentClass;
        private Player player;
        private List<SelectMethod> deniedMethods;

        public SelectMaterialListener(SelectMaterial selectMaterial, SelectMaterial parent, Player player) {
            this.parentClass = parent;
            this.player = player;
            this.deniedMethods = parent.getDeniedMethods();
        }

        @EventHandler
        private void onHit(PlayerInteractEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            if (this.deniedMethods.contains((Object)SelectMethod.HIT) && this.deniedMethods.contains((Object)SelectMethod.PAT)) {
                return;
            }
            event.setCancelled(true);
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null) {
                this.parentClass.setResponse(new ItemStack(clickedBlock.getType()));
            }
        }

        @EventHandler
        private void onSelect(InventoryClickEvent event) {
            if (this.player != event.getWhoClicked()) {
                return;
            }
            if (this.deniedMethods.contains((Object)SelectMethod.SELECT)) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                    return;
                }
                event.getView().close();
                this.parentClass.setResponse(new ItemStack(event.getCurrentItem()));
            });
        }

        @EventHandler
        private void onCommand(PlayerCommandPreprocessEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                this.parentClass.setCancelled(true);
                this.parentClass.execute();
            });
        }

        @EventHandler
        private void onChat(AsyncChatEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                String message = PlainTextComponentSerializer.plainText().serialize(event.message());
                if (ChatUtils.isExitKeyword(message)) {
                    this.parentClass.setCancelled(true);
                    this.parentClass.execute();
                }
                if (this.deniedMethods.contains((Object)SelectMethod.CHAT)) {
                    return;
                }
                if (!this.deniedMethods.contains((Object)SelectMethod.CHAT)) {
                    this.parentClass.setResponse(message);
                }
            });
        }
    }
}

