/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import playerquests.Core;
import playerquests.builder.fx.FXBuilder;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.quest.action.CraftAction;
import playerquests.builder.quest.action.NarrateAction;
import playerquests.builder.quest.action.NoneAction;
import playerquests.builder.quest.action.RequestItemAction;
import playerquests.builder.quest.action.RewardItemAction;
import playerquests.builder.quest.action.SpeakAction;
import playerquests.builder.quest.action.TakeItemAction;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.data.ActionTweaks;
import playerquests.builder.quest.action.listener.ActionListener;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.action.option.NPCOption;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.npc.EntityNPC;
import playerquests.builder.quest.npc.NPCType;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.quest.QuestClient;
import playerquests.client.quest.QuestDiary;
import playerquests.product.FX;
import playerquests.product.Quest;
import playerquests.product.fx.ParticleFX;
import playerquests.utility.event.ActionCompletionEvent;
import playerquests.utility.singleton.Database;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NoneAction.class, name="NoneAction"), @JsonSubTypes.Type(value=SpeakAction.class, name="SpeakAction"), @JsonSubTypes.Type(value=RequestItemAction.class, name="RequestItemAction"), @JsonSubTypes.Type(value=RewardItemAction.class, name="RewardItemAction"), @JsonSubTypes.Type(value=TakeItemAction.class, name="TakeItemAction"), @JsonSubTypes.Type(value=CraftAction.class, name="CraftAction"), @JsonSubTypes.Type(value=NarrateAction.class, name="NarrateAction"), @JsonSubTypes.Type(value=WalkAction.class, name="WalkAction")})
public abstract class QuestAction<A extends QuestAction<A, L>, L extends ActionListener<A>> {
    @JsonBackReference
    private QuestStage stage;
    @JsonManagedReference
    @JsonProperty(value="data")
    private ActionData actionData = new ActionData(this, null, null, null);
    @JsonProperty(value="label")
    private String label;

    public QuestAction() {
    }

    protected QuestAction(QuestStage stage) {
        this.stage = stage;
    }

    @JsonIgnore
    public abstract List<Class<? extends ActionOption>> getOptions();

    @JsonIgnore
    public abstract List<Class<? extends ActionCondition>> getConditionBlocklist();

    @JsonIgnore
    public abstract List<ActionTweaks> getTweaks();

    @JsonIgnore
    public QuestStage getStage() {
        return this.stage;
    }

    @JsonBackReference
    public void setStage(QuestStage stage) {
        if (stage == null) {
            return;
        }
        this.stage = stage;
    }

    public void setID(String id) {
        this.actionData.setID(id);
    }

    @JsonIgnore
    public String getID() {
        return this.actionData.getID();
    }

    public String toString() {
        return this.getID();
    }

    @JsonIgnore
    public abstract String getName();

    public void run(QuesterData questerData) {
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
            this.prepare(questerData);
            this.startParticleFX(questerData);
            this.startListener(questerData);
        });
    }

    protected abstract void prepare(QuesterData var1);

    public void check(QuesterData questerData) {
        this.check(questerData, false);
    }

    public void check(QuesterData questerData, boolean bypassClash) {
        boolean conditionsUnmet = this.getData().getConditions().stream().anyMatch(conditional -> {
            if (conditional.isMet(questerData)) {
                return false;
            }
            conditional.startListener(questerData);
            this.stop(questerData, true);
            return true;
        });
        if (conditionsUnmet) {
            return;
        }
        if (!bypassClash && !questerData.resolveClashes(this)) {
            return;
        }
        if (!this.isCompleted(questerData)) {
            this.failure(questerData);
            return;
        }
        this.success(questerData);
        this.stop(questerData);
    }

    protected abstract boolean isCompleted(QuesterData var1);

    public void stop(QuesterData questerData) {
        this.stop(questerData, false);
    }

    public void stop(QuesterData questerData, boolean halt) {
        questerData.stopListener(this);
        questerData.getFX(this).forEach(FX::stopEffect);
        questerData.getNPCs().forEach(npc -> {
            if (!((QuestAction)npc.getKey()).equals(this)) {
                return;
            }
            ((QuestNPC)npc.getValue()).despawn(this, questerData.getQuester());
        });
        boolean wasUntracked = questerData.getQuester().untrackAction(this);
        this.getData().getConditions().forEach(condition -> condition.cleanUp(questerData, this.getData()));
        if (!halt && wasUntracked) {
            this.proceed(questerData);
            Bukkit.getServer().getPluginManager().callEvent((Event)new ActionCompletionEvent(this, questerData));
        }
    }

    protected abstract Class<?> getListenerType();

    protected abstract void success(QuesterData var1);

    protected abstract void failure(QuesterData var1);

    protected abstract L startListener(QuesterData var1);

    protected void startParticleFX(QuesterData questerData) {
        if (this.getTweaks().contains((Object)ActionTweaks.NO_FX)) {
            return;
        }
        QuestClient quester = questerData.getQuester();
        QuestDiary questerDiary = quester.getDiary();
        Player player = quester.getPlayer();
        ParticleFX particleFX = questerDiary.getActionParticle();
        FXBuilder fxBuilder = new FXBuilder();
        Optional.ofNullable(this.getLocation()).ifPresent(l -> {
            LocationData location = new LocationData((LocationData)l);
            Quest quest = this.getStage().getQuest();
            NPCOption npcOption = this.actionData.getOption(NPCOption.class).get();
            location.setX(location.getX() + 0.5);
            location.setZ(location.getZ() + 0.5);
            QuestNPC npc = npcOption.getNPC(quest);
            NPCType npcType = npc.getAssigned();
            if (npcType instanceof EntityNPC) {
                NPC citizen = questerData.getCitizenNPC(this, npc);
                location.setY(location.getY() + citizen.getEntity().getHeight() + 0.5);
            } else {
                location.setY(location.getY() + 1.5);
            }
            fxBuilder.addParticle(particleFX, location);
        });
        questerData.addFX(this, fxBuilder.run(player));
    }

    public ActionData getData() {
        return this.actionData;
    }

    public static List<Class<? extends QuestAction<?, ?>>> getAllTypes() {
        JsonSubTypes jsonSubTypes = QuestAction.class.getDeclaredAnnotation(JsonSubTypes.class);
        return Arrays.stream(jsonSubTypes.value()).map(JsonSubTypes.Type::value).filter(QuestAction.class::isAssignableFrom).map(clazz -> clazz).toList();
    }

    public abstract GUISlot createSlot(GUIBuilder var1, Integer var2);

    @JsonIgnore
    public Optional<String> isValid() {
        return this.getData().getOptions().stream().map(ActionOption::isValid).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public void proceed(QuesterData questerData) {
        List<StagePath> nextActions = this.getData().getNextActions();
        String diaryID = questerData.getQuester().getDiary().getID();
        String questID = this.getStage().getQuest().getID();
        StagePath actionPath = new StagePath(this.getStage(), List.of(this));
        Database.getInstance().setDiaryEntryCompletion(diaryID, questID, actionPath, true);
        if (!nextActions.isEmpty()) {
            questerData.getQuester().start(nextActions, this.actionData.getAction().getStage().getQuest());
        }
    }

    public Optional<String> delete() {
        return this.getStage().removeAction(this);
    }

    @JsonIgnore
    public abstract LocationData getLocation();

    public QuestNPC spawnNPC(QuesterData questerData) {
        QuestClient quester = questerData.getQuester();
        Quest quest = this.getStage().getQuest();
        NPCOption npcOption = this.getData().getOption(NPCOption.class).orElseGet(null);
        if (npcOption == null || npcOption.isValid().isPresent()) {
            return null;
        }
        QuestNPC npc = npcOption.getNPC(quest);
        npc.spawn(this, quester);
        return npc;
    }

    protected QuestNPC despawnNPC(QuesterData questerData) {
        QuestClient quester = questerData.getQuester();
        Quest quest = this.getStage().getQuest();
        Optional<NPCOption> npcOption = this.getData().getOption(NPCOption.class);
        if (npcOption.isPresent()) {
            QuestNPC npc = npcOption.get().getNPC(quest);
            npc.despawn(this, quester);
            return npc;
        }
        throw new IllegalStateException("Tried to unplace an NPC for an action with no NPCOption added");
    }

    @JsonIgnore
    public String getLabel() {
        if (this.label == null) {
            return this.getID();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public String getActionStateText(boolean isSelected, boolean isStartPoint) {
        if (isSelected) {
            return "Selected";
        }
        return isStartPoint ? "Start Point" : "Select";
    }

    public String getActionStateText(boolean isStartPoint) {
        return this.getActionStateText(false, isStartPoint);
    }

    public Material getActionStateItem(boolean isSelected, boolean isStartPoint) {
        if (isSelected) {
            return Material.POWERED_RAIL;
        }
        return isStartPoint ? Material.DETECTOR_RAIL : Material.RAIL;
    }

    public Material getActionStateItem(boolean isStartPoint) {
        return this.getActionStateItem(false, isStartPoint);
    }
}

