/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action;

import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.data.ActionTweaks;
import playerquests.builder.quest.action.listener.RewardItemListener;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.action.option.ItemsOption;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.product.Quest;
import playerquests.utility.singleton.QuestRegistry;

public class RewardItemAction
extends QuestAction<RewardItemAction, RewardItemListener> {
    @Override
    public List<Class<? extends ActionOption>> getOptions() {
        return List.of(ItemsOption.class);
    }

    @Override
    public List<Class<? extends ActionCondition>> getConditionBlocklist() {
        return List.of();
    }

    @Override
    public List<ActionTweaks> getTweaks() {
        return List.of();
    }

    @Override
    public String getName() {
        return "Reward Item";
    }

    @Override
    protected void prepare(QuesterData questerData) {
    }

    @Override
    protected boolean isCompleted(QuesterData questerData) {
        return true;
    }

    @Override
    protected Class<?> getListenerType() {
        return RewardItemListener.class;
    }

    @Override
    protected void success(QuesterData questerData) {
        Player player = questerData.getQuester().getPlayer();
        ItemsOption itemsOption = this.getData().getOption(ItemsOption.class).get();
        player.sendMessage(String.format("%n<%s>", "Dropping reward"));
        itemsOption.getItems().forEach((item, amount) -> player.sendMessage(String.format("- %s (%d)", item.getName(), amount)));
        player.sendMessage("");
        Location playerLocation = player.getLocation();
        Quest quest = this.getStage().getQuest();
        QuestRegistry.getInstance().updateInventoryItem(quest, itemsOption.getItems(), (itemSerialisable, amount) -> {
            ItemStack itemStack = itemSerialisable.toItemStack();
            itemStack.setAmount(amount);
            playerLocation.getWorld().dropItem(playerLocation, itemStack);
        }, true);
    }

    @Override
    protected void failure(QuesterData questerData) {
    }

    @Override
    protected RewardItemListener startListener(QuesterData questerData) {
        return new RewardItemListener(this, questerData);
    }

    @Override
    public GUISlot createSlot(GUIBuilder gui, Integer slot) {
        return new GUISlot(gui, slot).setLabel(this.getName()).setDescription(List.of("Gives the quester ", "items.")).setItem(Material.CHEST);
    }

    @Override
    public Optional<String> isValid() {
        if (this.getData().getOption(ItemsOption.class).get().getItems().isEmpty()) {
            return Optional.of("No items are set, try choosing some items in the action options.");
        }
        return Optional.empty();
    }

    @Override
    public LocationData getLocation() {
        return null;
    }
}

